﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ucPartAdd.ascx.cs" Inherits="PirTickets.ucPartAdd" %>
<%@ Register Assembly="obout_ImageZoom_NET" Namespace="OboutInc.ImageZoom" TagPrefix="obout" %>
<%@ Register Assembly="obout_Window_NET" Namespace="OboutInc.Window" TagPrefix="owd" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>

<table border="0" style="width: 100%">
    <tr>
        <td class="style12" colspan="2">
            <script type="text/javascript">
                function onBeforeClientDelete(record) {
                    if (confirm("Are you sure you want to remove this part?") == false) {
                        return false;
                    }
                    return true;
                }
            </script>
            <cc1:Grid ID="gridParts" runat="server" AllowPaging="True" AllowSorting="False" AutoGenerateColumns="false" datakeynames="id"
                Width="100%" DataSourceID="SqlDataSourceParts" OnSelect="gridParts_Select" AllowAddingRecords="False" EmptyDataText="No Listed Parts included in this Repair"
                OnDeleteCommand="gridParts_DeleteCommand" AutoPostBackOnSelect="False" AllowFiltering="False" FolderStyle="~/Styles/style_5" AllowGrouping="False" AllowRecordSelection="False"
                Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100,500" AllowMultiRecordSelection="False" AllowPageSizeSelection="False"
                OnBeforeClientDelete="onBeforeClientDelete">
                <Columns>                    
                    <cc1:Column DataField="id" HeaderText="Id" InsertVisible="False" Index="0" ReadOnly="True"  Width="10px" Visible="false"/>       
                    <cc1:Column DataField="partid" HeaderText="partid" InsertVisible="False" Index="0" ReadOnly="True"  Width="10px" Visible="false" />
                    <cc1:Column AllowDelete="true" Width="70px"></cc1:Column>
                     <cc1:Column DataField="partno" HeaderText="Part No." SortExpression="partno" Width="100px">
                        <TemplateSettings TemplateId="tempView"  />
                    </cc1:Column>
                    <cc1:Column DataField="partno" HeaderText="Part No."  Width="100px" />
                    <cc1:Column DataField="partname" HeaderText="Name"   Width="100%" />
                    <cc1:Column DataField="quantity" HeaderText="Qty" Width="50px" />
                    <cc1:Column DataField="total" HeaderText="Cost"  Width="70px" />
                    <cc1:Column DataField="filepath" HeaderText="img" Width="150px">
                        <TemplateSettings TemplateId="tempimg" />   
                    </cc1:Column>
                </Columns>
                <Templates >
                    <cc1:GridTemplate runat="server" ID="tempView"  >
                        <Template >
                            <a href='PartsEdit.aspx?id=<%# Container.DataItem["partID"] %>' target="_blank">
                                <asp:Label ID="lblId" runat="server" Text='View' />
                            </a>
                        </Template>
                    </cc1:GridTemplate>
                    <cc1:GridTemplate runat="server" ID="tempimg">
                        <Template>              
                            <img src='<%# Container.DataItem["filepath"] %>' alt='<%# Container.DataItem["partname"] %>' style="width: 50px" />       
                        </Template>
                    </cc1:GridTemplate>
                </Templates>
            </cc1:Grid>

            <asp:SqlDataSource ID="SqlDataSourceParts" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                SelectCommand="getPartsUsed" SelectCommandType="StoredProcedure"> 
                <SelectParameters>
                    <asp:SessionParameter Name="repairID" SessionField="repID" Type="Int32" />
                </SelectParameters>
            </asp:SqlDataSource>
        </td>
    </tr>
    <tr>
        <td class="style12" colspan="2">&nbsp;</td>
    </tr>

    <tr>
        <td class="style27">Listed Parts Cost:</td>
        <td class="style13">
            <asp:Label ID="lblpartsReplacedCost" runat="server" Text="0.00"></asp:Label>
        </td>
    </tr>
    <tr>
        <td class="style27">
            <input id="btParts" type="button" value="Add Part" onclick="wdParts.Open();wdParts.bringToFront();wdParts.screenCenter();" />
        </td>
        <td class="style13">&nbsp;</td>
    </tr>
    <tr>
        <td class="style19" colspan="2"></td>
    </tr>
</table>


<script type="text/javascript">
    function onClientSelect(arrSelectedRecords) {
        var sMessage="";
        for (var i = 0; i < arrSelectedRecords.length; i++) {
            var record = arrSelectedRecords[i];
            sMessage = record.id;
            document.getElementById('<%=lblPartName.ClientID %>').innerText = record.partname;
        }
        hdnPart.Value = sMessage;
        btAdd.enable();
    }
</script>

<owd:Window ID="wdParts" runat="server" IsModal="true" Title="Add New Part" IsResizable="True" IsDraggable="True" MinHeight="800" MinWidth="800" Overflow="AUTO" VisibleOnLoad="false" Opacity="100" StyleFolder="Styles/wdstyles/blue">
    <table>
        <tr>
            <td colspan="2">
                <asp:HiddenField ID="hdnPart" ClientIDMode="Static" runat="server"  />
                <cc1:Grid ID="gridPartsStore" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false"  AllowMultiRecordSelection="false" datakeynames="id"
                    Width="700px" DataSourceID="dsPartsList" OnSelect="gridPartsStore_Select" AllowAddingRecords="False" EmptyDataText="No Listed Parts included in the Store"
                    AutoPostBackOnSelect="False" AllowFiltering="True"  FolderStyle="~/Styles/style_5" AllowGrouping="True" AllowRecordSelection="True" Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100,500">
                    <ClientSideEvents OnClientSelect="onClientSelect"  />
                    <Columns>
                        <cc1:Column DataField="id" HeaderText="Id" InsertVisible="False" Index="0" ReadOnly="True" Width="10px" Visible="false" />
                        <cc1:Column DataField="partno" HeaderText="Part No." SortExpression="partno" Width="100px" Index="1" />
                        <cc1:Column DataField="partname" HeaderText="Name" SortExpression="partname" Index="2" Width="150px" />
                        <cc1:Column DataField="categoryname" HeaderText="Category" SortExpression="categoryname" Index="3" Width="150px" />
                        <cc1:Column DataField="quant" HeaderText="Quantity"  Index="4" ItemStyle-HorizontalAlign="Center" Width="100px" />
                        <cc1:Column DataField="reorder" HeaderText="Reorder" Width="100px" />
                        <cc1:Column DataField="filepath" HeaderText="Img">
                            <TemplateSettings TemplateId="tempimg2" />
                        </cc1:Column>
                    </Columns>
                    <Templates>
                        <cc1:GridTemplate runat="server" ID="GridTemplate1">
                            <Template>
                                <a href='PartsEdit.aspx?id=<%# Container.DataItem["partID"] %>' target="_blank">
                                    <asp:Label ID="lblId" runat="server" Text='View' />
                                </a>
                            </Template>
                        </cc1:GridTemplate>
                        <cc1:GridTemplate runat="server" ID="tempimg2">
                            <Template>
                                <img src='<%# Container.DataItem["filepath"] %>' alt='<%# Container.DataItem["partname"] %>' style="width:50px" />
                                <%--<obout:ImageZoom ID="ImageZoom1" runat="server" ImageUrl='<%# Container.DataItem["filepath"] %>' Thumnailwidth="30px" BigImageUrl='<%# Container.DataItem["filepath"] %>' />--%>
                            </Template>
                        </cc1:GridTemplate>
                    </Templates>
                </cc1:Grid>
   
            </td>
        </tr>
        <tr>
            <td>

                <asp:Label ID="Label1" runat="server" Text="Selected Part:"></asp:Label>
                <asp:Label ID="lblPartName" runat="server" Text="None"></asp:Label><br />

                <asp:Label ID="Label3" runat="server" Text="Quantity:"></asp:Label>
                <asp:TextBox ID="txtQuant" runat="server" Height="20px" Width="57px">1</asp:TextBox>
                <cc2:OboutButton ID="btAdd" ClientIDMode="Static" runat="server" Text="Add" Height="25px" OnClick="btAdd_Click" Width="58px" Enabled="false" ></cc2:OboutButton>
       
            </td>
            <td>
                <strong>Category</strong>
                <asp:DropDownList ID="Ddcategory" runat="server" OnSelectedIndexChanged="Ddcategory_SelectedIndexChanged"  AutoPostBack="True" >
                </asp:DropDownList>

                <asp:SqlDataSource ID="SqlDataSource2" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                    SelectCommand="SELECT id,categoryname,description FROM partscategory" >                    
                </asp:SqlDataSource>
            </td>
        </tr>
        <tr>
            <td>
                <br />
                <asp:Button ID="btnComplete" runat="server" Text="Ok" OnClick="btnComplete_Click" Style="width: 80px" />
                <input id="Button1" type="button" value="Cancel" onclick="wdParts.Close();" style="width: 80px" />    </td>
            <td style="text-align:left">
                <br />
                <br />
           
            </td>
        </tr>
    </table>
    <asp:SqlDataSource ID="dsPartsList" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT dbo.partsstore.id, dbo.partsstore.partno, dbo.partsstore.partname, dbo.partsstore.description, dbo.partsstore.category, dbo.partsstore.quant, dbo.partsstore.reorder, 
                          dbo.partscategory.categoryname,
                              (SELECT TOP (1) filepath
                                FROM dbo.vwPartImages
                                WHERE (PartId = dbo.partsstore.id)) AS filepath
                                    FROM dbo.partsstore INNER JOIN
                                            dbo.partscategory ON dbo.partsstore.category = dbo.partscategory.id order by partsstore.partname">

    </asp:SqlDataSource>
</owd:Window>
