﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="TicketList.aspx.cs" Inherits="PirTickets.TicketList" %>

<%@ Register Assembly="DayPilot" Namespace="DayPilot.Web.Ui" TagPrefix="DayPilot" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Src="~/ucPartsRTMSchedule.ascx" TagPrefix="uc1" TagName="ucPartsRTMSchedule" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">
        <asp:Label ID="lblOutstanding" runat="server" Text="These are the repairs you have outstanding:"></asp:Label>
        <br />
        <br />
        <asp:Button ID="btAdd" runat="server" OnClick="btAdd_Click"
            Text="Add New Repair" />
        <br />

        <asp:TabContainer ID="TabContainer1" runat="server" ActiveTabIndex="0" TabStripPlacement="Top">
            <asp:TabPanel ID="TabPanel1" runat="server" HeaderText="Latest Repairs">
                <ContentTemplate>
                    <div class="well">
                        <cc1:Grid ID="gridRepairList" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="OrderID"
                            Width="95%" AllowAddingRecords="False" AutoPostBackOnSelect="true" DataSourceID="SqlDataRepairs"
                            AllowFiltering="True" FolderStyle="~/Styles/style_5" OnSelect="gridRepairList_Select" EmptyDataText="You have no repairs outstanding"
                            AllowGrouping="true" AllowRecordSelection="true" Serialize="false" PageSize="100" PageSizeOptions="10,20,50,100">
                            <Columns>
                                <cc1:Column DataField="OrderID" HeaderText="ID" ReadOnly="True" SortExpression="OrderID" Width="50px" />
                                <cc1:Column DataField="model" HeaderText="Model" Width="180px" SortExpression="manufacturer" />
                                <cc1:Column DataField="CustomerName" HeaderText="Customer" SortExpression="CustomerName" />
                                <cc1:Column DataField="DateReceived" DataFormatString="{0:d}" HeaderText="Received" ReadOnly="True" SortExpression="DateReceived" Width="80px" />
                                <cc1:Column DataField="status" HeaderText="Status" Width="100px" />
                                <cc1:Column DataField="Priority" HeaderText="Priority" SortExpression="Priority" Width="200px" />
                            </Columns>
                        </cc1:Grid>
                    </div>
                    <asp:SqlDataSource ID="SqlDataRepairs" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="getRepairsforTech" SelectCommandType="StoredProcedure">
                        <SelectParameters>
                            <asp:SessionParameter Name="empid" SessionField="empid" />
                        </SelectParameters>
                    </asp:SqlDataSource>
                    <asp:SqlDataSource ID="SqlDataSourceReadOnly" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="getRepairsforReadOnly" SelectCommandType="StoredProcedure">
                        <SelectParameters>
                            <asp:Parameter Name="complete" runat="server" DefaultValue="0" DbType="Int32" />
                        </SelectParameters>
                    </asp:SqlDataSource>
                </ContentTemplate>
            </asp:TabPanel>

            <asp:TabPanel ID="TabPanel5" runat="server" HeaderText="Completed Repairs">
                <ContentTemplate>
                    <div class="well">
                        <cc1:Grid ID="gridComplete" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="OrderID"
                            Width="95%" AllowAddingRecords="False" AutoPostBackOnSelect="true" DataSourceID="dsComplete"
                            AllowFiltering="True" FolderStyle="~/Styles/style_5" OnSelect="gridComplete_Select" EmptyDataText="You have no repairs outstanding"
                            AllowGrouping="true" AllowRecordSelection="true" Serialize="false" PageSize="20" PageSizeOptions="10,20,50,100">
                            <Columns>
                                <cc1:Column DataField="OrderID" HeaderText="ID" ReadOnly="True" SortExpression="OrderID" Width="50px" />
                                <cc1:Column DataField="model" HeaderText="Model" Width="180px" SortExpression="manufacturer" />
                                <cc1:Column DataField="DateReceived" DataFormatString="{0:d}" HeaderText="Received" ReadOnly="True" SortExpression="DateReceived" Width="100px" />
                                <cc1:Column DataField="status" HeaderText="Status" Width="200px" />
                                <cc1:Column DataField="Priority" HeaderText="Priority" SortExpression="Priority" Width="200px" />
                            </Columns>
                        </cc1:Grid>
                    </div>
                    <asp:SqlDataSource ID="dsComplete" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="getCompletedRepairsforTech" SelectCommandType="StoredProcedure">
                        <SelectParameters>
                            <asp:SessionParameter Name="empid" SessionField="empid" />
                        </SelectParameters>
                    </asp:SqlDataSource>
                    <asp:SqlDataSource ID="dsCompleteReadonly" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="getRepairsforReadOnly" SelectCommandType="StoredProcedure">
                        <SelectParameters>
                            <asp:Parameter Name="complete" runat="server" DefaultValue="1" DbType="Int32" />
                        </SelectParameters>
                    </asp:SqlDataSource>
                </ContentTemplate>
            </asp:TabPanel>
            <asp:TabPanel ID="TabPanel2" runat="server" HeaderText="Repairs to Peer Check">

                <ContentTemplate>
                    <div class="well">
                        <cc1:Grid ID="gridPeerReviews" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="OrderID"
                            Width="95%" AllowAddingRecords="False" AutoPostBackOnSelect="true"
                            AllowFiltering="True" FolderStyle="~/Styles/style_5" OnSelect="gridPeerReviews_Select" EmptyDataText="You have no repairs to peer check"
                            AllowGrouping="true" AllowRecordSelection="true" Serialize="false" PageSize="20" PageSizeOptions="10,20,50,100">
                            <Columns>
                                <cc1:Column DataField="OrderID" HeaderText="ID" ReadOnly="True" SortExpression="OrderID" Width="50px" />
                                <cc1:Column DataField="manufacturer" HeaderText="manufacturer" Width="180px" SortExpression="manufacturer" />
                                <cc1:Column DataField="model" HeaderText="Model" Width="180px" SortExpression="model" />
                                <cc1:Column DataField="Received" DataFormatString="{0:d}" HeaderText="Received" ReadOnly="True" SortExpression="Received" Width="100px" />
                            </Columns>
                        </cc1:Grid>
                    </div>
                </ContentTemplate>

            </asp:TabPanel>
            <asp:TabPanel ID="TabPanel3" runat="server" HeaderText="Schedule">
                <ContentTemplate>
                    <uc1:ucPartsRTMSchedule runat="server" ID="RTMSchedule" />
                </ContentTemplate>
            </asp:TabPanel>
            <asp:TabPanel ID="TabPanel4" runat="server" HeaderText="RTM repairs">
                <ContentTemplate>
                    <div class="well">
                        <h3>Parts Returned to Manufacturer for Repair</h3>
                        <asp:Label ID="Label2" runat="server" Text=""></asp:Label>
                        <cc1:Grid ID="GridRTM" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="repairID"
                            Width="95%" AllowAddingRecords="False" AutoPostBackOnSelect="true" DataSourceID="SqlDataSourceRTM"
                            AllowFiltering="True" FolderStyle="~/Styles/style_5" OnSelect="gridRepairList_Select" EmptyDataText="You have no repairs outstanding"
                            AllowGrouping="true" AllowRecordSelection="true" Serialize="false" PageSize="20" PageSizeOptions="10,20,50,100">
                            <Columns>
                                <cc1:Column DataField="repairID" HeaderText="Repair" ReadOnly="True" SortExpression="repairID" Width="80px" />
                                <cc1:Column DataField="partno" HeaderText="Part no." ReadOnly="True" SortExpression="partno" Width="80px" />
                                <cc1:Column DataField="partname" HeaderText="Part" ReadOnly="True" SortExpression="partname" Width="150px" />
                                <cc1:Column DataField="serial" HeaderText="serial" ReadOnly="True" SortExpression="serial" Width="80px" />
                                <cc1:Column DataField="datesent" HeaderText="Sent" ReadOnly="True" SortExpression="datesent" Width="80px" DataFormatString="{0:d}" />
                                <cc1:Column DataField="expReturnDate" HeaderText="Exp. Return" ReadOnly="True" SortExpression="expReturnDate" Width="80px" DataFormatString="{0:d}" />
                                <cc1:Column DataField="techReminderSent" HeaderText="Rem. Sent" ReadOnly="True" SortExpression="techReminderSent" Width="80px" DataFormatString="{0:d}" />
                                <cc1:Column DataField="imageUrl">
                                    <TemplateSettings TemplateId="tempImage" />
                                </cc1:Column>
                            </Columns>
                            <Templates>
                                <cc1:GridTemplate ID="tempImage" runat="server">
                                    <Template>
                                        <asp:Image ID="repImg" runat="server" Width="50px" ImageUrl='<%# Container.DataItem["imageUrl"] %>' />
                                    </Template>
                                </cc1:GridTemplate>
                            </Templates>
                        </cc1:Grid>
                    </div>
                    <asp:SqlDataSource ID="SqlDataSourceRTM" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="Select id,repairID, partID, partno,partname,serial,datesent ,expReturnDate,techReminderSent,imageUrl from vwPartsRTM where techID = @techID">
                        <SelectParameters>
                            <asp:SessionParameter Name="techID" SessionField="empID" />
                        </SelectParameters>
                    </asp:SqlDataSource>
                </ContentTemplate>
            </asp:TabPanel>
        </asp:TabContainer>
    </div>
</asp:Content>
