<%@ Page Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" Inherits="PirTickets.TicketForm" Title="Ticket" CodeBehind="TicketForm.aspx.cs" %>

<%@ Register Assembly="obout_Window_NET" Namespace="OboutInc.Window" TagPrefix="owd" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <style type="text/css">
    </style>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">

        <h2>Book in New Repair</h2>
        <table cellpadding="2" border="0" class="table table-striped">
            <tr>
                <td>Date Received:</td>
                <td></td>
                <td colspan="4">
                    <asp:Label ID="txtDateReceived" runat="server" ReadOnly="True"></asp:Label>
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Received By:</td>
                <td valign="top"></td>
                <td valign="top">
                    <asp:Label ID="lblReceiver" runat="server" Text="Label"></asp:Label></td>
                <td valign="top" style="text-align: left" colspan="3"></td>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td>Book in Point:</td>
                <td></td>
                <td>
                    <asp:DropDownList ID="ddSites" runat="server" DataSourceID="SqlDataSites"
                        DataTextField="sitename" DataValueField="id" OnSelectedIndexChanged="ddSites_SelectedIndexChanged">
                    </asp:DropDownList>

                </td>
                <td colspan="2">Pickup Point:</td>
                <td>
                    <asp:DropDownList ID="ddSitesPickup" runat="server" DataSourceID="SqlDataSites"
                        DataTextField="sitename" DataValueField="id" OnSelectedIndexChanged="ddSitesPickup_SelectedIndexChanged">
                    </asp:DropDownList>
                </td>
                <td>
                    <asp:SqlDataSource ID="SqlDataSites" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="SELECT [id], [sitename] FROM [sites] order by sitename"></asp:SqlDataSource>
                </td>
            </tr>
            <tr>
                <td valign="top">Customer:
                     <asp:RadioButtonList ID="rbCustOrder" runat="server" AutoPostBack="True" Font-Size="Small"
                         OnSelectedIndexChanged="rbCustOrder_SelectedIndexChanged" RepeatDirection="Horizontal"
                         ToolTip="Customer Name Order" Width="190px" Height="50px">

                         <asp:ListItem Selected="True" Value="0">First Name</asp:ListItem>
                         <asp:ListItem Value="1">Surname</asp:ListItem>
                     </asp:RadioButtonList>

                </td>
                <td valign="top">&nbsp;</td>
                <td colspan="4">
                    <asp:UpdatePanel ID="upCustomers" runat="server" ClientIDMode="Static" OnLoad="upCustomers_Load">
                        <ContentTemplate>
                            <asp:DropDownList ID="DDCustomerID" runat="server" ClientIDMode="Static" OnDataBound="DDCustomerID_DataBound" AutoPostBack="false">
                            </asp:DropDownList>


                        </ContentTemplate>
                    </asp:UpdatePanel>
                    <input id="btnFind" type="button" value="Search" onclick="wdSearch.Open(); wdSearch.bringToFront(); wdSearch.screenCenter();" />
                    <input type="button" value="New Customer" onclick="wdNewCust.Open(); wdNewCust.bringToFront(); wdNewCust.screenCenter();" />

                    <asp:Label ID="lblcustfound" runat="server" ForeColor="Blue" Text="Label" Visible="False"></asp:Label>
                    <br />
                    Search:&nbsp; Name/ID:
                    <asp:TextBox ID="txtUserID" runat="server" MaxLength="20" Width="91px"></asp:TextBox>
                    &nbsp;Phone No:
                    <asp:TextBox ID="txtPhoneSearch" runat="server" MaxLength="20" Width="105px"></asp:TextBox>
                    <asp:Button ID="btSearch" runat="server" OnClick="btSearch_Click1" Text="Find" CausesValidation="true" />
                </td>
                <td></td>
            </tr>

            <tr>
                <td valign="top">Manufacturer Name:</td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                        <ContentTemplate>
                            <asp:DropDownList ID="ddManufacturer" runat="server"
                                DataSourceID="SqlDataManufacturer" DataTextField="manufacturer"
                                DataValueField="id" OnSelectedIndexChanged="ddManufacturer_SelectedIndexChanged"
                                AutoPostBack="True">
                            </asp:DropDownList>
                            <asp:SqlDataSource ID="SqlDataManufacturer" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                SelectCommand="SELECT [id], [manufacturer] FROM [Manufacturers] order by [manufacturer]"></asp:SqlDataSource>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">New Manufacturer:</td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel9" runat="server">
                        <ContentTemplate>
                            <asp:TextBox ID="txtOtherMan" runat="server" MaxLength="50"></asp:TextBox>&nbsp;
                    <asp:Button ID="btOtherMan" runat="server" OnClick="btOtherMan_Click"
                        Style="width: 154px" Text="Add Manufacturer" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td>&nbsp;</td>
            </tr>

            <tr>
                <td valign="top">Model:<br />
                </td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel6" runat="server">
                        <ContentTemplate>
                            <asp:DropDownList ID="DDLModel" runat="server" DataSourceID="SqlDataModel"
                                DataTextField="ModelName" DataValueField="modelid" OnSelectedIndexChanged="DDLModel_SelectedIndexChanged">
                            </asp:DropDownList>
                            <asp:SqlDataSource ID="SqlDataModel" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                SelectCommand="SELECT [modelid], [ModelName] FROM [Models] WHERE ([manufacturerID] = @manufacturerID) ORDER BY ModelName">
                                <SelectParameters>
                                    <asp:ControlParameter ControlID="ddManufacturer" Name="manufacturerID"
                                        PropertyName="SelectedValue" Type="Int32" />
                                </SelectParameters>
                            </asp:SqlDataSource>
                            <asp:Label runat="server" ID="lblModelCount"></asp:Label>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                   
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Unknown model:</td>
                <td>&nbsp;</td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel7" runat="server">
                        <ContentTemplate>
                            <asp:TextBox ID="TxtModelNew" MaxLength="50" runat="server" Width="230px" />&nbsp;
                <asp:Button ID="btModel" runat="server" OnClick="btModel_Click" Text="Add Model" CausesValidation="False" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>

                <td>&nbsp;</td>
            </tr>

            <tr>
                <td valign="top">Serial Number:</td>
                <td>&nbsp;</td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                        <ContentTemplate>
                            <asp:TextBox ID="txtSerial" runat="server" MaxLength="50" OnTextChanged="txtSerial_TextChanged" Width="146px" AutoPostBack="True"></asp:TextBox>
                            <asp:HyperLink ID="hlPrevious" runat="server" Visible="False" Target="_blank">Previous Repair History</asp:HyperLink>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td>&nbsp;</td>

            </tr>
            <tr>
                <td valign="top">Password:</td>
                <td>&nbsp;</td>
                <td colspan="4">
                    <asp:TextBox ID="txtPassword" runat="server" MaxLength="50" Width="164px"></asp:TextBox>
                </td>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblref" runat="server" Text="External Reference No."></asp:Label></td>
                <td>&nbsp;</td>
                <td colspan="4">
                    <asp:TextBox ID="txtref" runat="server" MaxLength="150" Width="216px"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Equipment Description:</td>
                <td></td>
                <td colspan="4">
                    <asp:TextBox ID="TxtEquipmentDescription" runat="server" Columns="60" Height="59px" Rows="10" TextMode="MultiLine" Width="100%" /></td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Problem Description:</td>
                <td></td>
                <td colspan="4">
                    <asp:TextBox ID="TxtProblemDescription" runat="server" TextMode="MultiLine"
                        MaxLength="500" Height="84px" Width="100%"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Any physical Damage?</td>
                <td></td>
                <td colspan="4">
                    <asp:TextBox ID="TxtPhysicalDamage" runat="server" TextMode="MultiLine"
                        MaxLength="500" Height="61px" Width="100%"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>Preffered Shippping:</td>
                <td></td>
                <td colspan="4">
                    <asp:DropDownList ID="TxtShipVia" MaxLength="50" runat="server" /></td>
                <td></td>
            </tr>
            <tr>
                <td>Assigned Technician:</td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel8" runat="server">
                        <ContentTemplate>
                            <asp:DropDownList ID="TxtAssignedTechnician" runat="server"
                                Width="142px" Enabled="False" />&nbsp;<asp:CheckBox ID="cbAssign" runat="server"
                                    Text="Assign" OnCheckedChanged="CheckBox1_CheckedChanged" AutoPostBack="True" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td></td>
            </tr>
            <tr>
                <td valign="top">Priority:</td>
                <td>&nbsp;</td>
                <td colspan="4">
                    <asp:DropDownList ID="DDPriority" runat="server" DataSourceID="SqlDataPriority"
                        DataTextField="priority_name" DataValueField="level" AutoPostBack="True">
                    </asp:DropDownList>
                    <asp:SqlDataSource ID="SqlDataPriority" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="SELECT [level], [priority_name] FROM [priority]"></asp:SqlDataSource>
                </td>
                <td>&nbsp;</td>
            </tr>
            <tr>
                <td>Date Promised:</td>
                <td></td>
                <td colspan="2">
                    <asp:TextBox ID="DPDatePromised" runat="server"></asp:TextBox>
                    <asp:CalendarExtender ID="CalendarExtender1" runat="server" TargetControlID="DPDatePromised"></asp:CalendarExtender>
                </td>
                <td colspan="2"></td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblBag" runat="server" Text="With Laptop Bag:"></asp:Label>
                </td>
                <td></td>
                <td colspan="2">
                    <asp:CheckBox ID="CbxWithBezel" runat="server" /></td>
                <td colspan="2"></td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblCharger" runat="server" Text="With Charger:"></asp:Label>
                </td>
                <td></td>
                <td colspan="2">
                    <asp:CheckBox ID="CbxWithPowerCord" runat="server" /></td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="lblBatt" runat="server" Text="With Battery:"></asp:Label>
                </td>
                <td></td>
                <td colspan="2">
                    <asp:CheckBox ID="CbxWithSignalCable" runat="server" /></td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:Label ID="Label1" runat="server" Text="Miscellaneous Items:"></asp:Label>
                </td>
                <td></td>
                <td colspan="2">
                    <asp:TextBox ID="txtMiscItems" runat="server" Height="68px" TextMode="MultiLine" Width="60%"></asp:TextBox></td>
                <td colspan="2"></td>
                <td></td>
            </tr>
            <tr>
                <td>Warranty Work:</td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel3" runat="server">
                        <ContentTemplate>
                            <asp:CheckBox ID="CbxWarrantyWork" runat="server" OnCheckedChanged="CbxWarrantyWork_CheckedChanged" AutoPostBack="True" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>
                    <asp:UpdatePanel ID="UpdatePanel4" runat="server">
                        <ContentTemplate>
                            <asp:Label ID="lblWarranty" runat="server" Text="Warranty Expires:"></asp:Label>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td></td>
                <td colspan="4">
                    <asp:UpdatePanel ID="UpdatePanel5" runat="server">
                        <ContentTemplate>
                            <asp:TextBox ID="dpWarranty" runat="server"></asp:TextBox>
                            <asp:CalendarExtender ID="CalendarExtender2" runat="server" TargetControlID="dpWarranty"></asp:CalendarExtender>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>Diagnostic Fee:</td>
                <td></td>
                <td colspan="4">
                    <asp:TextBox ID="txtdiagnostic" runat="server"  TextMode="Number" Width="89px" step="any"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>Estimated Cost:</td>
                <td></td>
                <td colspan="4">
                    <asp:TextBox ID="txtEstimatedCost" runat="server"  TextMode="Number" Width="89px" step="any"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td>Deposit Paid:</td>
                <td></td>
                <td colspan="4">
                    <asp:SqlDataSource ID="SqlDataCosts" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                        SelectCommand="SELECT CAST(ROUND([CostVal],2) AS NUMERIC(8,2)) as CostVal FROM [Costs]"></asp:SqlDataSource>
                    <asp:TextBox ID="txtDepositDue" runat="server"  TextMode="Number" Width="89px" step="any"></asp:TextBox>
                </td>
                <td></td>
            </tr>
            <tr>
                <td colspan="2"></td>
                <td colspan="5">
                    <asp:Button ID="BtnUpdate" runat="server" Text="Submit" OnClick="BtnUpdate_Click" />&nbsp;&nbsp;
                <asp:Button ID="BtnCancel" CausesValidation="false" runat="server" Text="Cancel" OnClick="BtnCancel_Click" />&nbsp;&nbsp;
                </td>
            </tr>
        </table>

        <owd:Window ID="wdSearch" runat="server" Title="Find Customer" IsModal="true" IsResizable="True" IsDraggable="True" Height="800" Width="750"
            VisibleOnLoad="false" Overflow="AUTO" Opacity="100" StyleFolder="Styles/wdstyles/blue">
            <div class="well">
                <cc1:Grid ID="gridCustomers" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="CustomerID"
                    Width="95%" AllowAddingRecords="False" AutoPostBackOnSelect="true" DataSourceID="SqlDataCustomers"
                    AllowFiltering="True" FolderStyle="~/Styles/style_5" OnSelect="gridCustomers_Select"
                    AllowGrouping="true" AllowRecordSelection="true" Serialize="false" PageSize="20" PageSizeOptions="10,20,50,100">
                    <Columns>
                        <cc1:Column DataField="CustomerID" HeaderText="CustomerID" Visible="False" ReadOnly="True" SortExpression="CustomerID" Width="50px" />
                        <cc1:Column DataField="OrganizationName" HeaderText="OrganizationName" SortExpression="OrganizationName" Width="120px" />
                        <cc1:Column DataField="Username" HeaderText="Username" SortExpression="Username" Width="120px" />
                        <cc1:Column DataField="FirstName" HeaderText="FirstName" SortExpression="FirstName" Width="120px" />
                        <cc1:Column DataField="LastName" HeaderText="LastName" SortExpression="LastName" Width="120px" />
                        <cc1:Column DataField="address" HeaderText="Street" SortExpression="address" Width="120px" />
                        <cc1:Column DataField="City" HeaderText="City" SortExpression="City" Width="80px" />
                        <cc1:CheckBoxColumn DataField="Trader" HeaderText="Trader" />
                    </Columns>
                </cc1:Grid>

                <b>Search:</b>
                <table>
                    <tr>
                        <td>
                            <asp:HiddenField ID="Hidden1" runat="server" />
                        </td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td></td>
                        <td align="right"></td>
                        <td align="right">
                            <input id="Button2" type="button" value="Cancel" onclick="wdSearch.Close();" /></td>
                        <td></td>
                    </tr>
                </table>
            </div>
            <asp:SqlDataSource ID="SqlDataCustomers" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                SelectCommand="SELECT [CustomerID], [OrganizationName], [Username], [FirstName], [LastName],[address], [City], [Trader] FROM [Customers]"></asp:SqlDataSource>
        </owd:Window>

        <owd:Window ID="wdNewCust" runat="server" Title="Enter New Customer Details" IsModal="true" IsResizable="True" IsDraggable="True" Height="900" Width="750"
            VisibleOnLoad="false" Opacity="100" StyleFolder="Styles/wdstyles/blue" ShowCloseButton="true">
            <div class="form-group ">
                <table cellpadding="2" border="0">
                    <tr>
                        <td></td>
                        <td>&nbsp;</td>
                        <td>
                            <asp:TextBox ID="TxtCustomerID" MaxLength="10" runat="server" ReadOnly="True" Visible="false" CssClass="form-control">New</asp:TextBox>
                        </td>
                        <td class="style4">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>Organization Name:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtOrganizationName" MaxLength="50" runat="server" Width="282px" /></td>
                        <td class="style4">Trade? :<asp:CheckBox ID="cbTrade" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>Contact Title:</td>
                        <td>&nbsp;</td>
                        <td>
                            <asp:TextBox ID="TxtContactTitle" MaxLength="50" runat="server"
                                Width="74px" /></td>
                        <td class="style4">&nbsp;</td>
                    </tr>
                    <tr>
                        <td>First Name:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtFirstName" MaxLength="50" runat="server" /></td>
                        <td class="style4">
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtFirstName" ErrorMessage="First Name Required" ValidationGroup="vgNew"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>Last Name:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtLastName" MaxLength="50" runat="server"
                                Width="171px" /></td>
                        <td class="style4">
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ControlToValidate="TxtLastName" ErrorMessage="Surname Required" ValidationGroup="vgNew"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td>Address:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtAddress" MaxLength="255" runat="server" Width="239px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Region:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtRegion" MaxLength="50" runat="server" Width="165px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>City:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtCity" MaxLength="50" runat="server" Width="155px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>State:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtState" MaxLength="50" runat="server" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Postal Code:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtPostalCode" MaxLength="20" runat="server" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Country:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtCountry" MaxLength="50" runat="server">USA</asp:TextBox>
                        </td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Email:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtEmailName" MaxLength="50" runat="server" Width="307px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Phone Number:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtPhoneNumber" ClientIDMode="Static" MaxLength="30" runat="server"
                                Width="171px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Mobile Phone:</td>
                        <td>&nbsp;</td>
                        <td>
                            <asp:TextBox ID="TxtMobilePhone" MaxLength="30" runat="server"
                                Width="171px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Fax Number:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtFaxNumber" MaxLength="30" runat="server"
                                Width="168px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td valign="top">Note:</td>
                        <td></td>
                        <td>
                            <asp:TextBox ID="TxtNote" MaxLength="1073741823"
                                TextMode="MultiLine" Rows="5" runat="server" Width="293px" /></td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Payment Terms:</td>
                        <td></td>
                        <td>
                            <asp:DropDownList ID="DDPayment" runat="server" DataSourceID="SqlDataPayments" DataTextField="PaymentTerms" DataValueField="ID">
                            </asp:DropDownList>
                            <asp:SqlDataSource ID="SqlDataPayments" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                SelectCommand="SELECT [ID], [PaymentTerms], [NumberOfDays] FROM [PaymentTerms]"></asp:SqlDataSource>
                        </td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>Preferred<br />
                            Delivery Route:</td>
                        <td></td>
                        <td>
                            <asp:DropDownList ID="ddShipping" runat="server" DataSourceID="SqlDataShipping" DataTextField="ShipMethod" DataValueField="ID">
                            </asp:DropDownList>
                            <asp:SqlDataSource ID="SqlDataShipping" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                SelectCommand="SELECT [ID], [ShipMethod] FROM [shipvia]"></asp:SqlDataSource>
                        </td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                        <td></td>
                        <td>&nbsp;</td>
                        <td class="style4"></td>
                    </tr>
                    <tr>
                        <td colspan="2"></td>
                        <td colspan="2">
                            <asp:Button ID="BtnUpdateView" runat="server" Text="Save" OnClick="BtnUpdateView_Click" Width="136px" ValidationGroup="vgNew" />&nbsp;
                        <asp:Button ID="Button1" CausesValidation="false" runat="server" Text="Cancel" OnClientClick="wdNewCust.Close();" Width="127px" />
                        </td>
                    </tr>
                </table>
            </div>
        </owd:Window>

    </div>

</asp:Content>
