﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="StatusList.aspx.cs" Inherits="PirTickets.StatusList" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">
        <h2>
            <asp:Label ID="lblHeader" runat="server" Text="Repair Status Maintenance"></asp:Label></h2>
        <br />
        <asp:Panel ID="pnlHeader" runat="server">
            <asp:Button ID="btAdd" runat="server" OnClick="btAdd_Click" Text="Add New Status" />
            <br />
            <br />
        </asp:Panel>
        <asp:UpdatePanel ID="UpdatePanel1" runat="server">

            <ContentTemplate>
                <asp:GridView ID="gvStatus" runat="server" AutoGenerateColumns="False" AutoGenerateEditButton="True" DataKeyNames="id" DataSourceID="SqlDataStatus"
                    ShowFooter="True" Width="450px" OnRowCommand="gvStatus_RowCommand" OnRowDeleting="gvStatus_RowDeleting" SkinID="gridviewSkin" OnRowDataBound="gvStatus_RowDataBound">

                    <Columns>
                        <asp:ButtonField ButtonType="Image" CausesValidation="True" ImageUrl="~/images/arrow_58.gif" CommandName="up" />
                        <asp:ButtonField ButtonType="Image" ImageUrl="~/images/arrow_57.gif" CommandName="down" />
                        <asp:BoundField DataField="Id" HeaderText="No." SortExpression="Id" ControlStyle-Width="0px" />
                        <asp:BoundField DataField="status_order" HeaderText="Order" SortExpression="status_order" Visible="false" />
                        <asp:BoundField DataField="status_name" HeaderText="Status" SortExpression="status_name" />
                        <asp:TemplateField HeaderText="">
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkDelete" CommandName="Delete" runat="server">Delete</asp:LinkButton>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>

            </ContentTemplate>
        </asp:UpdatePanel>
        <table>
            <tr>
                <td>
                    <asp:UpdatePanel ID="upThreshhold" runat="server">
                        <ContentTemplate>
                            Repair Completed Threshold:<asp:DropDownList ID="ddcomplete"
                                runat="server" DataSourceID="SqlDataStatus" DataTextField="status_name" DataValueField="id">
                            </asp:DropDownList>
                        </ContentTemplate>
                    </asp:UpdatePanel>

                </td>
                <td>
                    <asp:UpdatePanel ID="upUpdate" runat="server">
                        <ContentTemplate>
                            <asp:Button ID="btSave" runat="server" Text="Update" OnClick="btSave_Click" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
            </tr>
        </table>
        <asp:UpdatePanel ID="upNewStatus" runat="server">
            <ContentTemplate>
                <h2>Enter New Status:</h2>
                <table cellpadding="2" border="0">
                    <tr>
                        <td>Status Name:</td>
                        <td><span style="color: red;">*</span></td>
                        <td>
                            <asp:TextBox ID="txtNameIns" runat="server" MaxLength="50" Text='<%# Bind("status_name") %>'></asp:TextBox>
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="RfvStatus_order0" runat="server" ControlToValidate="txtNameIns" Display="Dynamic" ErrorMessage="Status Name is required." />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2"></td>
                        <td>
                            <asp:Button ID="btnSave" Text="Save" runat="server" OnClick="btnSave_Click" />
                            <asp:Button ID="btnCancel" Text="Cancel" runat="server"  CausesValidation="false" OnClick="btnCancel_Click" />
                        </td>
                        <td></td>
                    </tr>
                </table>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:SqlDataSource ID="SqlDataStatus" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
            SelectCommand="SELECT [id], [status_order], [status_name] FROM [statuses]"
            UpdateCommand="update [statuses] set  [status_name] =@status_name where id=@id"
            InsertCommand="Insert into statuses (status_name) values ( @status_name) "></asp:SqlDataSource>
    </div>
</asp:Content>
