#

# Automated Web Deployment Script

# ===============================

#

# General Information:

# -------------------

# - When running the script, you may need to set your execution policy.

# - When running this script using other automated deployment environments

# you may only have access to the command line so you can invoke it like so:

# cmd /c powershell -ExecutionPolicy "UnRestricted" .\ApplicationDeployment.ps1 \\Path\To\Binaries\Folder

#

# Step A: Validate passed parameters

# ----------------------------------

$BinariesRoot = $args[0]

if($BinariesRoot -eq $null)

{

echo "Invalid Usage. You must specify the path to the binaries root as a parameter."

exit 1

}

else

{

if((Test-Path $BinariesRoot) -eq $False)

{

echo "[$BinariesRoot] is not a valid binaries path."

exit 1

}

}

# Step B: Initialisation of parameters

# ------------------------------------

$ApplicationName = "WebApplication"

$WebDocumentRoot = "C:\www\$ApplicationName\$(Get-Date -f hh.mm.ss_dd.MMMM.yyyy)"

$WebsiteName = "$ApplicationName_" + $(Get-Date -f hh.mm.ss_dd.MMMM.yyyy)

# Step C: Begin deployment tasks

# ------------------------------

# Step C(1). Create a new directory which contains the Build Output

New-Item -Type Directory -Path $WebDocumentRoot -Force

# Step C(2). Copy build output

Copy-Item -Force -Recurse $BinariesRoot\* $WebDocumentRoot

# Step C(3). Setup IIS

# Step C(3)(i). Stop all existing sites

C:\Windows\SysWOW64\inetsrv\appcmd.exe list site /xml /state:"$=started" | C:\Windows\SysWOW64\inetsrv\appcmd.exe stop site /in

# Step C(3)(ii). Add App Pools

# Note: Replace Application.UI.Web with the name of your application(s)

C:\Windows\SysWOW64\inetsrv\appcmd.exe ADD APPPOOL /NAME:$WebsiteName-Application.UI.Web /MANAGEDRUNTIMEVERSION:v4.0

# Step C(3)(iii). Add Website and additional bindings

# Note: Replace net tcp binding port if required

C:\Windows\SysWOW64\inetsrv\appcmd.exe ADD SITE /NAME:$WebsiteName /BINDINGS:http://*:80 /PHYSICALPATH:$WebDocumentRoot\_PublishedWebsites

$SetupNetTcpBinding = "`"C:\Windows\SysWOW64\inetsrv\appcmd.exe SET SITE /SITE.NAME:$WebsiteName /+BINDINGS.[protocol='net.tcp',bindingInformation='8080:*']`""

cmd /c $SetupNetTcpBinding

# Step C(3)(iv). Add Applications to Sites

# Note: Replace Application.UI.Web with the name of your application(s)

C:\Windows\SysWOW64\inetsrv\appcmd.exe ADD APP /SITE.NAME:$WebsiteName /PATH:/Application.UI.Web /PHYSICALPATH:$WebDocumentRoot\_PublishedWebsites\Application.UI.Web

# Step C(3)(v). Enable net.tcp protocol on only the ApplicationService

C:\Windows\SysWOW64\inetsrv\appcmd.exe SET APP /APP.NAME:$WebsiteName/ApplicationService /ENABLEDPROTOCOLS:"http,net.tcp"

# Step C(3)(vi). Start Websites and reset iis

C:\Windows\SysWOW64\inetsrv\appcmd.exe start site /SITE.NAME:"$WebsiteName"

C:\Windows\System32\iisreset.exe