﻿IF EXISTS (
        SELECT type_desc, type
        FROM sys.procedures WITH(NOLOCK)
        WHERE NAME = 'getRepairsforReadOnly'
            AND type = 'P'
      )
     DROP PROCEDURE dbo.getRepairsforReadOnly
~

CREATE PROCEDURE [dbo].[getRepairsforReadOnly] 
	@complete int
AS
BEGIN
SELECT RepairData.OrderID, Manufacturers.manufacturer + '  ' + Models.ModelName AS model, 
RepairData.DateReceived, statuses.status_name AS status, priority.priority_name AS priority, 
Employees.UserName
        FROM RepairData left join Manufacturers ON Manufacturers.id = RepairData.ManufacturerName left JOIN
      Models ON RepairData.ModelNumber = Models.modelid INNER JOIN
      statuses ON RepairData.Status = statuses.id INNER JOIN
      priority ON RepairData.Priority = priority.id INNER JOIN
      Employees ON RepairData.AssignedTechnician = Employees.EmployeeID 
      
      where RepairData.RepairCompleted = @complete
END

~


SET IDENTITY_INSERT [configuration] ON
INSERT INTO [configuration] ([confid],[cms],[name],[value])VALUES(54,0,'subscriberModel','0')
SET IDENTITY_INSERT [configuration] OFF


~

