﻿

CREATE PROCEDURE dbo.tr_RepairQuickSearch 

	@Serial varchar(20)
AS
BEGIN

IF @Serial ='' 
	return null

IF @Serial not like '%[^0-9]%' 

SELECT dbo.RepairData.OrderID, dbo.Manufacturers.manufacturer + ' ' +  dbo.Models.ModelName as model, dbo.RepairData.DateReceived AS Received, dbo.RepairData.RepairCompleted, dbo.priority.priority_name, dbo.RepairData.Priority, 
case when assignedtechnician is not null and [Status] < convert(varchar(3),(SELECT [value] FROM [configuration] where confid =21)) then dbo.Employees.FirstName + ' ' + dbo.Employees.LastName else [status_name] end as statusname,
         CASE WHEN dbo.Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE dbo.Customers.FirstName + ' ' + dbo.Customers.LastName END AS cust, dbo.Customers.LastName, dbo.RepairData.site, dbo.sites.sitename, dbo.RepairData.SerialNumber, dbo.Employees.FirstName + ' ' + dbo.Employees.LastName AS empname, 
         dbo.Employees.UserName, dbo.RepairData.Status, dbo.RepairData.AssignedTechnician, dbo.RepairData.externalref, dbo.Customers.FirstName, dbo.RepairData.UneconomicalToRepair,Customers.PhoneNumber
FROM  dbo.sites RIGHT OUTER JOIN
         dbo.Employees RIGHT OUTER JOIN
         dbo.RepairData ON dbo.Employees.EmployeeID = dbo.RepairData.AssignedTechnician ON dbo.sites.id = dbo.RepairData.site LEFT OUTER JOIN
         dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
         dbo.statuses ON dbo.RepairData.Status = dbo.statuses.id LEFT OUTER JOIN
         dbo.priority ON dbo.RepairData.Priority = dbo.priority.[level] LEFT OUTER JOIN
         dbo.Models ON dbo.RepairData.ModelNumber = dbo.Models.modelid LEFT OUTER JOIN
         dbo.Manufacturers ON dbo.RepairData.ManufacturerName = dbo.Manufacturers.id
		 where (dbo.RepairData.OrderID = @Serial or dbo.RepairData.serialnumber like '%' + @Serial + '%' or Customers.PhoneNumber like '%' + @Serial + '%')
	ELSE
	SELECT dbo.RepairData.OrderID, dbo.Manufacturers.manufacturer + ' ' +  dbo.Models.ModelName as model, dbo.RepairData.DateReceived AS Received, dbo.RepairData.RepairCompleted, dbo.priority.priority_name, dbo.RepairData.Priority, 
case when assignedtechnician is not null and [Status] < convert(varchar(3),(SELECT [value] FROM [configuration] where confid =21)) then dbo.Employees.FirstName + ' ' + dbo.Employees.LastName else [status_name] end as statusname,
         CASE WHEN dbo.Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE dbo.Customers.FirstName + ' ' + dbo.Customers.LastName END AS cust, dbo.Customers.LastName, dbo.RepairData.site, dbo.sites.sitename, dbo.RepairData.SerialNumber, dbo.Employees.FirstName + ' ' + dbo.Employees.LastName AS empname, 
         dbo.Employees.UserName, dbo.RepairData.Status, dbo.RepairData.AssignedTechnician, dbo.RepairData.externalref, dbo.Customers.FirstName, dbo.RepairData.UneconomicalToRepair,Customers.PhoneNumber
FROM  dbo.sites RIGHT OUTER JOIN
         dbo.Employees RIGHT OUTER JOIN
         dbo.RepairData ON dbo.Employees.EmployeeID = dbo.RepairData.AssignedTechnician ON dbo.sites.id = dbo.RepairData.site LEFT OUTER JOIN
         dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
         dbo.statuses ON dbo.RepairData.Status = dbo.statuses.id LEFT OUTER JOIN
         dbo.priority ON dbo.RepairData.Priority = dbo.priority.[level] LEFT OUTER JOIN
         dbo.Models ON dbo.RepairData.ModelNumber = dbo.Models.modelid LEFT OUTER JOIN
         dbo.Manufacturers ON dbo.RepairData.ManufacturerName = dbo.Manufacturers.id
		 where (dbo.RepairData.serialnumber like '%' + @Serial + '%' or Customers.PhoneNumber like '%' + @Serial + '%')
END

~

ALTER VIEW [dbo].[vwPartsUsedbyCategory]
AS
SELECT dbo.partsused.partID, dbo.partsstore.partname, dbo.partsstore.cost, dbo.partscategory.categoryname, dbo.partsused.repairID, dbo.Customers.OrganizationName + ' ' + dbo.Customers.FirstName + ' ' + dbo.Customers.LastName AS cust, dbo.RepairData.DateReceived AS DateReceived
FROM  dbo.partsused INNER JOIN
         dbo.partsstore ON dbo.partsused.partID = dbo.partsstore.id INNER JOIN
         dbo.RepairData ON dbo.partsused.repairID = dbo.RepairData.OrderID INNER JOIN
         dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
         dbo.partscategory ON dbo.partsstore.category = dbo.partscategory.id


~

