﻿ALTER  TABLE sales
add completed bit null

~

ALTER PROCEDURE [dbo].[tr_getPartsByCategory]
	@category int

AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

SELECT DISTINCT partsstore.id as PartId, partsstore.partno,
	dbo.partsstore.category,partsstore.cost,partsstore.description,partsstore.partname,partsstore.quant ,
	(select top 1 dbo.Images.filepath from Images LEFT OUTER JOIN
	dbo.PartImages q ON q.ImageId = dbo.Images.id where q.PartId = P.PartId) as filepath,m.manufacturer

	FROM dbo.partsstore LEFt JOIN
	dbo.PartImages P ON dbo.partsstore.id = P.PartId 
	LEFT JOIN dbo.manufacturers m on m.id = dbo.partsstore.manufacturerID
	where partsstore.category =  @category
                      
END


~


CREATE PROCEDURE dbo.tr_RepairQuickSearch 

	@Serial varchar(20)
AS
BEGIN

IF @Serial ='' 
	return null

IF @Serial not like '%[^0-9]%' 

SELECT dbo.RepairData.OrderID, dbo.Manufacturers.manufacturer + ' ' +  dbo.Models.ModelName as model, dbo.RepairData.DateReceived AS Received, dbo.RepairData.RepairCompleted, dbo.priority.priority_name, dbo.RepairData.Priority, 
case when assignedtechnician is not null and [Status] < convert(varchar(3),(SELECT [value] FROM [configuration] where confid =21)) then dbo.Employees.FirstName + ' ' + dbo.Employees.LastName else [status_name] end as statusname,
         CASE WHEN dbo.Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE dbo.Customers.FirstName + ' ' + dbo.Customers.LastName END AS cust, dbo.Customers.LastName, dbo.RepairData.site, dbo.sites.sitename, dbo.RepairData.SerialNumber, dbo.Employees.FirstName + ' ' + dbo.Employees.LastName AS empname, 
         dbo.Employees.UserName, dbo.RepairData.Status, dbo.RepairData.AssignedTechnician, dbo.RepairData.externalref, dbo.Customers.FirstName, dbo.RepairData.UneconomicalToRepair,Customers.PhoneNumber
FROM  dbo.sites RIGHT OUTER JOIN
         dbo.Employees RIGHT OUTER JOIN
         dbo.RepairData ON dbo.Employees.EmployeeID = dbo.RepairData.AssignedTechnician ON dbo.sites.id = dbo.RepairData.site LEFT OUTER JOIN
         dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
         dbo.statuses ON dbo.RepairData.Status = dbo.statuses.id LEFT OUTER JOIN
         dbo.priority ON dbo.RepairData.Priority = dbo.priority.[level] LEFT OUTER JOIN
         dbo.Models ON dbo.RepairData.ModelNumber = dbo.Models.modelid LEFT OUTER JOIN
         dbo.Manufacturers ON dbo.RepairData.ManufacturerName = dbo.Manufacturers.id
		 where (dbo.RepairData.OrderID = @Serial or dbo.RepairData.serialnumber like '%' + @Serial + '%' or Customers.PhoneNumber like '%' + @Serial + '%')
	ELSE
	SELECT dbo.RepairData.OrderID, dbo.Manufacturers.manufacturer + ' ' +  dbo.Models.ModelName as model, dbo.RepairData.DateReceived AS Received, dbo.RepairData.RepairCompleted, dbo.priority.priority_name, dbo.RepairData.Priority, 
case when assignedtechnician is not null and [Status] < convert(varchar(3),(SELECT [value] FROM [configuration] where confid =21)) then dbo.Employees.FirstName + ' ' + dbo.Employees.LastName else [status_name] end as statusname,
         CASE WHEN dbo.Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE dbo.Customers.FirstName + ' ' + dbo.Customers.LastName END AS cust, dbo.Customers.LastName, dbo.RepairData.site, dbo.sites.sitename, dbo.RepairData.SerialNumber, dbo.Employees.FirstName + ' ' + dbo.Employees.LastName AS empname, 
         dbo.Employees.UserName, dbo.RepairData.Status, dbo.RepairData.AssignedTechnician, dbo.RepairData.externalref, dbo.Customers.FirstName, dbo.RepairData.UneconomicalToRepair,Customers.PhoneNumber
FROM  dbo.sites RIGHT OUTER JOIN
         dbo.Employees RIGHT OUTER JOIN
         dbo.RepairData ON dbo.Employees.EmployeeID = dbo.RepairData.AssignedTechnician ON dbo.sites.id = dbo.RepairData.site LEFT OUTER JOIN
         dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
         dbo.statuses ON dbo.RepairData.Status = dbo.statuses.id LEFT OUTER JOIN
         dbo.priority ON dbo.RepairData.Priority = dbo.priority.[level] LEFT OUTER JOIN
         dbo.Models ON dbo.RepairData.ModelNumber = dbo.Models.modelid LEFT OUTER JOIN
         dbo.Manufacturers ON dbo.RepairData.ManufacturerName = dbo.Manufacturers.id
		 where (dbo.RepairData.serialnumber like '%' + @Serial + '%' or Customers.PhoneNumber like '%' + @Serial + '%')
END

~