﻿/****** Object:  StoredProcedure [repairs].[getRepairsforTech]    Script Date: 22/05/2016 18:22:03 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [getRepairsforTech] 
	@empId int
AS
BEGIN
SELECT RepairData.OrderID,

CASE WHEN (RepairData.manufacturername IS NOT NULL AND RepairData.manufacturername <> '') THEN ISNULL(Manufacturers.manufacturer,'') + '  ' + ISNULL(Models.ModelName,'') 
ELSE ISNULL(RepairData.NewManufacturer,'') + ' ' + ISNULL(RepairData.NewModel,'') END
AS model, 

RepairData.DateReceived, statuses.status_name AS status, priority.priority_name AS priority, 
Employees.UserName,
(CASE WHEN (cu.organizationName is null or cu.organizationName ='') THEN ISNULL(cu.FirstName,'') + ' ' + ISNULL(cu.LastName ,'')
ELSE cu.organizationName END) AS customerName

FROM RepairData left join Manufacturers ON Manufacturers.id = RepairData.ManufacturerName left JOIN
Models ON RepairData.ModelNumber = Models.modelid INNER JOIN
statuses ON RepairData.Status = statuses.id INNER JOIN
priority ON RepairData.Priority = priority.id INNER JOIN
Employees ON RepairData.AssignedTechnician = Employees.EmployeeID 
inner join Customers cu on repairdata.CustomerID = Cu.CustomerID
      
where AssignedTechnician=@empId and RepairData.RepairCompleted = 0
END

~

SET IDENTITY_INSERT [configuration] ON
INSERT INTO configuration ([confid],cms,name,value) values(52,0, 'RestricAssTechstoLoc','1')
SET IDENTITY_INSERT [configuration] OFF

~