﻿

/****** Object:  View [dbo].[vwRepairsAll]    Script Date: 03/15/2015 15:02:54 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[vwRepairsAll]'))
DROP VIEW [dbo].[vwRepairsAll]
~

/****** Object:  View [dbo].[vwRepairsAll]    Script Date: 03/15/2015 15:02:55 ******/
SET ANSI_NULLS ON
~

SET QUOTED_IDENTIFIER ON
~

CREATE VIEW [dbo].[vwRepairsAll]
AS
SELECT     dbo.RepairData.OrderID, dbo.Manufacturers.manufacturer, dbo.Models.ModelName, dbo.RepairData.DateReceived AS Received, dbo.RepairData.RepairCompleted, 
                      dbo.priority.priority_name, dbo.RepairData.Priority, dbo.statuses.status_name, 
                      CASE WHEN dbo.Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE dbo.Customers.FirstName + ' ' + dbo.Customers.LastName END AS cust,
                       dbo.Customers.LastName, dbo.RepairData.site, dbo.sites.sitename, dbo.RepairData.SerialNumber, 
                      dbo.Employees.FirstName + ' ' + dbo.Employees.LastName AS empname, dbo.Employees.UserName, dbo.RepairData.Status, dbo.RepairData.AssignedTechnician, 
                      dbo.RepairData.externalref, dbo.Customers.FirstName, dbo.RepairData.UneconomicalToRepair
FROM         dbo.sites RIGHT OUTER JOIN
                      dbo.Employees RIGHT OUTER JOIN
                      dbo.RepairData ON dbo.Employees.EmployeeID = dbo.RepairData.AssignedTechnician ON dbo.sites.id = dbo.RepairData.site LEFT OUTER JOIN
                      dbo.Customers ON dbo.RepairData.CustomerID = dbo.Customers.CustomerID LEFT OUTER JOIN
                      dbo.statuses ON dbo.RepairData.Status = dbo.statuses.id LEFT OUTER JOIN
                      dbo.priority ON dbo.RepairData.Priority = dbo.priority.[level] LEFT OUTER JOIN
                      dbo.Models ON dbo.RepairData.ModelNumber = dbo.Models.modelid LEFT OUTER JOIN
                      dbo.Manufacturers ON dbo.RepairData.ManufacturerName = dbo.Manufacturers.id

~







