/****** Object:  StoredProcedure [getRepairsforTech]    Script Date: 10/22/2014 15:41:56 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[getRepairsforTech]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[getRepairsforTech]

~

CREATE PROCEDURE [dbo].[getRepairsforTech] 
	@empId int
AS
BEGIN
SELECT RepairData.OrderID, Manufacturers.manufacturer + '  ' + Models.ModelName AS model, 
RepairData.DateReceived, statuses.status_name AS status, priority.priority_name AS priority, 
Employees.UserName
        FROM Manufacturers INNER JOIN
      RepairData ON Manufacturers.id = RepairData.ManufacturerName INNER JOIN
      Models ON RepairData.ModelNumber = Models.modelid INNER JOIN
      statuses ON RepairData.Status = statuses.id INNER JOIN
      priority ON RepairData.Priority = priority.id INNER JOIN
      Employees ON RepairData.AssignedTechnician = Employees.EmployeeID 
      
      where AssignedTechnician=@empId and RepairData.RepairCompleted = 0
END

~

CREATE PROCEDURE [dbo].[getCompletedRepairsforTech] 
	@empId int
AS
BEGIN
SELECT RepairData.OrderID, Manufacturers.manufacturer + '  ' + Models.ModelName AS model, 
RepairData.DateReceived, statuses.status_name AS status, priority.priority_name AS priority, 
Employees.UserName
        FROM Manufacturers INNER JOIN
      RepairData ON Manufacturers.id = RepairData.ManufacturerName INNER JOIN
      Models ON RepairData.ModelNumber = Models.modelid INNER JOIN
      statuses ON RepairData.Status = statuses.id INNER JOIN
      priority ON RepairData.Priority = priority.id INNER JOIN
      Employees ON RepairData.AssignedTechnician = Employees.EmployeeID 
      
      where AssignedTechnician=@empId and RepairData.RepairCompleted = 1
END

~

/****** Object:  View [vwCustomerTickets]    Script Date: 10/22/2014 15:41:06 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[vwCustomerTickets]'))
DROP VIEW [dbo].[vwCustomerTickets]
~


CREATE VIEW [dbo].[vwCustomerTickets]
AS
SELECT     RepairData.OrderID, Manufacturers.manufacturer, Models.ModelName, RepairData.DateReceived AS Received, RepairData.RepairCompleted, 
                      priority.priority_name, statuses.status_name, RepairData.CustomerID, RepairData.SerialNumber
FROM         Models RIGHT OUTER JOIN
                      statuses RIGHT OUTER JOIN
                      RepairData ON statuses.id = RepairData.Status LEFT OUTER JOIN
                      Manufacturers ON RepairData.ManufacturerName = Manufacturers.id ON Models.modelid = RepairData.ModelNumber LEFT OUTER JOIN
                      priority ON RepairData.Priority = priority.id

~

ALTER VIEW [dbo].[vwRepairsbyEmployees]
AS
SELECT     RepairData.OrderID, Manufacturers.manufacturer, Models.ModelName, RepairData.DateReceived AS Received, RepairData.RepairCompleted, 
                      priority.priority_name, statuses.status_name, RepairData.CustomerID, RepairData.SerialNumber, RepairData.AssignedTechnician, 
                      RepairData.UneconomicalToRepair, RepairData.externalref
FROM         Models RIGHT OUTER JOIN
                      statuses RIGHT OUTER JOIN
                      RepairData ON statuses.id = RepairData.Status LEFT OUTER JOIN
                      Manufacturers ON RepairData.ManufacturerName = Manufacturers.id ON Models.modelid = RepairData.ModelNumber LEFT OUTER JOIN
                      priority ON RepairData.Priority = priority.id

~

ALTER VIEW [dbo].[vwRepairsAll]
AS
SELECT     RepairData.OrderID, Manufacturers.manufacturer, Models.ModelName, RepairData.DateReceived AS Received, RepairData.RepairCompleted, 
                      priority.priority_name, RepairData.Priority, statuses.status_name, 
                      CASE WHEN Customers.OrganizationName <> '' THEN Customers.OrganizationName ELSE Customers.FirstName + ' ' + Customers.LastName END AS cust,
                       Customers.LastName, RepairData.site, sites.sitename, RepairData.SerialNumber, 
                      Employees.FirstName + ' ' + Employees.LastName AS empname, Employees.UserName, RepairData.Status, RepairData.AssignedTechnician, 
                      RepairData.externalref, Customers.FirstName
FROM         sites RIGHT OUTER JOIN
                      Employees RIGHT OUTER JOIN
                      RepairData ON Employees.EmployeeID = RepairData.AssignedTechnician ON sites.id = RepairData.site LEFT OUTER JOIN
                      Customers ON RepairData.CustomerID = Customers.CustomerID LEFT OUTER JOIN
                      statuses ON RepairData.Status = statuses.id LEFT OUTER JOIN
                      priority ON RepairData.Priority = priority.[level] LEFT OUTER JOIN
                      Models ON RepairData.ModelNumber = Models.modelid LEFT OUTER JOIN
                      Manufacturers ON RepairData.ManufacturerName = Manufacturers.id

~


/****** Object:  View [vwRepairsUnassigned]    Script Date: 10/22/2014 15:44:09 ******/


ALTER VIEW [dbo].[vwRepairsUnassigned]
AS
SELECT     RepairData.OrderID, Manufacturers.manufacturer, Models.ModelName, RepairData.DateReceived, RepairData.RepairCompleted, 
                      priority.priority_name, RepairData.Priority
FROM         Models RIGHT OUTER JOIN
                      priority RIGHT OUTER JOIN
                      RepairData ON priority.[level] = RepairData.Priority ON Models.modelid = RepairData.ModelNumber LEFT OUTER JOIN
                      Manufacturers ON RepairData.ManufacturerName = Manufacturers.id
WHERE     (RepairData.Status = 1)

~

