
if exists (select * from sysobjects where id = object_id(N'[historylog]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[historylog]
~
CREATE TABLE [dbo].[historylog] (
    [id]       INT           IDENTITY (1, 1) NOT NULL,
    [userid]   NVARCHAR (50) NULL,
    [logentry] TEXT          NULL,
    [date]     DATETIME      NULL,
    CONSTRAINT [constraint_PK_historylog] PRIMARY KEY CLUSTERED ([id] ASC)
);


~

ALTER TABLE [dbo].[Manufacturers]
    ADD [RTMContact] INT NULL;


~

ALTER TABLE [dbo].[partsstore]
    ADD [manufacturerID] INT NULL,
        [RTMContact]     INT NULL;

~

if exists (select * from sysobjects where id = object_id(N'[contact]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [contact]

~

CREATE TABLE [dbo].[contact] (
    [id]        INT            IDENTITY (1, 1) NOT NULL,
    [title]     NVARCHAR (50)  NULL,
    [firstname] NVARCHAR (50)  NULL,
    [surname]   NVARCHAR (50)  NULL,
    [tel]       NVARCHAR (50)  NULL,
    [mobile]    NVARCHAR (50)  NULL,
    [location]  INT            NOT NULL,
    [email]     NVARCHAR (100) NULL,
    CONSTRAINT [PK_contact] PRIMARY KEY CLUSTERED ([id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[Images]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[Images]

~

CREATE TABLE [dbo].[Images] (
    [id]       INT             IDENTITY (1, 1) NOT NULL,
    [filepath] NVARCHAR (150)  NOT NULL,
    [logid]    INT             NULL,
    [Note]     NVARCHAR (1000) NULL,
    CONSTRAINT [PK_Images] PRIMARY KEY CLUSTERED ([id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[location]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[location]

~

CREATE TABLE [dbo].[location] (
    [id]       INT           IDENTITY (1, 1) NOT NULL,
    [name]     NVARCHAR (50) NULL,
    [street]   NVARCHAR (50) NULL,
    [district] NVARCHAR (50) NULL,
    [town]     NVARCHAR (50) NULL,
    [county]   NVARCHAR (20) NULL,
    [postcode] NVARCHAR (10) NULL,
    [mapref]   NVARCHAR (20) NULL,
    CONSTRAINT [PK_location] PRIMARY KEY CLUSTERED ([id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[messageQueue]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[messageQueue]

~

CREATE TABLE [dbo].[messageQueue] (
    [id]          INT   IDENTITY(1,1)   NOT NULL,
    [techID]      INT      NOT NULL,
    [repairID]    INT      NULL,
    [RTMID]       INT      NULL,
    [partID]      INT      NULL,
    [priority]    INT      NOT NULL,
    [msgcreated]  DATETIME NULL,
    [msgRead]     DATETIME NULL,
    [description] TEXT     NULL,
    [complete]    BIT      NULL,
    [completed]   DATETIME NULL,
    CONSTRAINT [PK_messageQueue] PRIMARY KEY CLUSTERED ([id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[PartImages]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[PartImages]

~

CREATE TABLE [dbo].[PartImages] (
    [Id]      INT IDENTITY (1, 1) NOT NULL,
    [PartId]  INT NOT NULL,
    [ImageId] INT NOT NULL,
    CONSTRAINT [PK_PartImages] PRIMARY KEY CLUSTERED ([Id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[partRTM]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[partRTM]

~

CREATE TABLE [dbo].[partRTM](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[repairID] [int] NOT NULL,
	[partID] [int] NOT NULL,
	[serial] [nvarchar](100) NULL,
	[manufacturer] [int] NOT NULL,
	[datesent] [date] NOT NULL,
	[techID] [int] NOT NULL,
	[expReturnDate] [date] NULL,
	[alertTechIfOverdue] [bit] NOT NULL,
	[alertAdminIfOverdue] [bit] NOT NULL,
	[techReminderSent] [datetime] NULL,
	[adminReminderSent] [datetime] NULL,
	[partReturned] [bit] NOT NULL,
	[returned] [datetime] NULL,
	[workingAfterReturn] [bit] NULL,
	[Notes] [text] NULL,
	[contact] [int] NULL,
	[mainContact] [nvarchar](50) NULL,
	[contactsurname] [nvarchar](50) NULL,
	[contactTel] [nvarchar](50) NULL,
	[sentVia] [int] NULL,
	[courierCode] [nvarchar](50) NULL,
	[name] [nvarchar](50) NULL,
	[street] [nvarchar](50) NULL,
	[district] [nvarchar](50) NULL,
	[town] [nvarchar](50) NULL,
	[county] [nvarchar](20) NULL,
	[postcode] [nvarchar](10) NULL,
 CONSTRAINT [PK_partRTM] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

~
ALTER TABLE [dbo].[partRTM] ADD  CONSTRAINT [DF_partRTM_alertTechIfOverdue]  DEFAULT ((0)) FOR [alertTechIfOverdue]
~

ALTER TABLE [dbo].[partRTM] ADD  CONSTRAINT [DF_partRTM_alertAdminIfOverdue]  DEFAULT ((0)) FOR [alertAdminIfOverdue]
~

if exists (select * from sysobjects where id = object_id(N'[RepairImages]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[RepairImages]

~

CREATE TABLE [dbo].[RepairImages] (
    [Id]       INT IDENTITY (1, 1) NOT NULL,
    [RepairId] INT NOT NULL,
    [ImageId]  INT NOT NULL,
    CONSTRAINT [PK_RepairImages] PRIMARY KEY CLUSTERED ([Id] ASC)
);


~

if exists (select * from sysobjects where id = object_id(N'[ServiceImages]') and OBJECTPROPERTY(id, N'IsTable') = 1)
	drop TABLE [dbo].[ServiceImages]

~

CREATE TABLE [dbo].[ServiceImages] (
    [Id]        INT IDENTITY (1, 1) NOT NULL,
    [serviceId] INT NOT NULL,
    [ImageId]   INT NOT NULL,
    CONSTRAINT [PK_ServiceImages] PRIMARY KEY CLUSTERED ([Id] ASC)
);

~

ALTER VIEW [dbo].[vwRepairsUnassigned]
AS
SELECT     RepairData.OrderID, Manufacturers.manufacturer, Models.ModelName, RepairData.DateReceived, RepairData.RepairCompleted, 
                      priority.priority_name, RepairData.Priority
FROM         Models RIGHT OUTER JOIN
                      priority RIGHT OUTER JOIN
                      RepairData ON priority.[level] = RepairData.Priority ON Models.modelid = RepairData.ModelNumber LEFT OUTER JOIN
                      Manufacturers ON RepairData.ManufacturerName = Manufacturers.id
WHERE     (RepairData.Status = 1)
~

ALTER VIEW [dbo].[vwTechswithRepairs]
AS
SELECT     EmployeeID, FirstName, LastName,
                          (SELECT     COUNT(1) AS Expr1
                            FROM          RepairData
                            WHERE      (AssignedTechnician = Employees.EmployeeID) AND (RepairCompleted = 0 OR
                                                   RepairCompleted IS NULL)) AS repairs
FROM         Employees
WHERE     ((SELECT     COUNT(1) AS Expr1
                         FROM         RepairData AS RepairData_1
                         WHERE     (AssignedTechnician = Employees.EmployeeID) AND (RepairCompleted = 0 OR
                                               RepairCompleted IS NULL)) > 0)
~

CREATE VIEW [dbo].vwContacts
AS
SELECT     contact.id, contact.title, contact.firstname, contact.surname, contact.tel, contact.mobile, contact.location, contact.email, 
                      location.name, location.street, location.district, location.town, location.county, location.postcode, location.mapref
FROM         contact INNER JOIN
                      location ON contact.location = location.id
~

CREATE VIEW [dbo].vwPartImages
AS
SELECT DISTINCT PartImages.PartId, Images.filepath, Images.Note, Images.id
FROM         Images RIGHT OUTER JOIN
                      PartImages ON Images.id = PartImages.ImageId
~

CREATE VIEW [dbo].vwPartList
AS
SELECT     partsstore.id, partsstore.partno, partsstore.partname, partsstore.description, partsstore.category, partsstore.quant, partsstore.reorder, 
                      partscategory.categoryname,
                          (SELECT     TOP (1) filepath
                            FROM          vwPartImages
                            WHERE      (PartId = partsstore.id)) AS filepath
FROM         partsstore INNER JOIN
                      partscategory ON partsstore.category = partscategory.id
~

CREATE VIEW [dbo].vwPartsRTM
AS
SELECT     a.id, a.repairID, a.partID, b.partno, b.partname, a.serial, d.manufacturer, a.datesent, a.techID, c.UserName, a.expReturnDate, a.alertTechIfOverdue, 
                      a.alertAdminIfOverdue, a.techReminderSent, a.adminReminderSent, a.partReturned, a.returned, a.workingAfterReturn, a.Notes, a.mainContact, a.contactTel, a.sentVia, 
                      a.courierCode,
                          (SELECT     filepath
                            FROM          Images
                            WHERE      (id = e.ImageId)) AS imageUrl
FROM         partRTM AS a LEFT OUTER JOIN
                      partsstore AS b ON a.partID = b.id INNER JOIN
                      Employees AS c ON a.techID = c.EmployeeID LEFT OUTER JOIN
                     Manufacturers AS d ON a.manufacturer = d.id LEFT OUTER JOIN
                     PartImages AS e ON a.partID = e.PartId
~

CREATE VIEW [dbo].vwRepairImages
AS
SELECT DISTINCT RepairImages.RepairId, Images.filepath, Images.Note, Images.id
FROM         Images RIGHT OUTER JOIN
                      RepairImages ON Images.id = RepairImages.ImageId
~

CREATE VIEW [dbo].vwServiceImages
AS
SELECT DISTINCT ServiceImages.serviceId, Images.filepath, Images.Note, Images.id
FROM         Images RIGHT OUTER JOIN
                      ServiceImages ON Images.id = ServiceImages.ImageId
~

SET IDENTITY_INSERT [configuration] ON 
INSERT configuration(confid,cms,name,value) VALUES('34',NULL,'tax1Name','Sales Tax')
INSERT configuration(confid,cms,name,value) VALUES('35',NULL,'tax1Rate','20')
INSERT configuration(confid,cms,name,value) VALUES('36',NULL,'tax1Parts','True')
INSERT configuration(confid,cms,name,value) VALUES('37',NULL,'tax1Misc','True')
INSERT configuration(confid,cms,name,value) VALUES('38',NULL,'tax1Serv','True')
INSERT configuration(confid,cms,name,value) VALUES('39',NULL,'tax2Name','Federal Tax')
INSERT configuration(confid,cms,name,value) VALUES('40',NULL,'tax2Rate','5')
INSERT configuration(confid,cms,name,value) VALUES('41',NULL,'tax2Parts','False')
INSERT configuration(confid,cms,name,value) VALUES('42',NULL,'tax2Misc','False')
INSERT configuration(confid,cms,name,value) VALUES('43',NULL,'tax2Serv','False')
INSERT configuration(confid,cms,name,value) VALUES('44',NULL,'tax1Labour','False') 
INSERT configuration(confid,cms,name,value) VALUES('45',NULL,'tax2Labour','False') 
SET IDENTITY_INSERT [configuration] OFF

~

CREATE VIEW [dbo].vwPartList
AS
SELECT     partsstore.id, partsstore.partno, partsstore.partname, partsstore.description, partsstore.category, partsstore.quant, partsstore.reorder, 
                      partscategory.categoryname,
                          (SELECT     TOP (1) filepath
                            FROM          vwPartImages
                            WHERE      (PartId = partsstore.id)) AS filepath
FROM         partsstore INNER JOIN
                      partscategory ON partsstore.category = partscategory.id

~