﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="Manufacturers.aspx.cs" Inherits="PirTickets.Manufacturers" ViewStateEncryptionMode="Never"  %>

<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <script type="text/javascript">
        function BeforeClientDelete(record) {
            if (confirm("Are you sure you want to remove " + record.manufacturer +"?") == false) {
                return false;
            }
            return true;
        }

        function BeforeClientDeleteModel(record) {
            if (confirm("Are you sure you want to remove " + record.ModelName + "?") == false) {
                return false;
            }
            return true;
        }
    </script>
    
    <asp:UpdateProgress ID="UpdateProgress1" runat="server" AssociatedUpdatePanelID="upPanel" >
    </asp:UpdateProgress>
    <asp:UpdatePanel runat="server" ID="upPanel"><ContentTemplate>
    <div class="jumbotron">
    <h2>Manufacturers</h2>

        <h4>Add New Manufacturer</h4>
        <asp:TextBox ID="TxtAdd" runat="server" MaxLength="50" Width="220px"></asp:TextBox>
        <asp:Button ID="badd" runat="server" onclick="badd_Click" Text="Add New" />
        <asp:Label ID="lblAlert" runat="server"></asp:Label>

        <cc1:Grid ID="gridManufacturers" runat="server" AllowPaging="True" AllowSorting="False" AutoGenerateColumns="true"
            datakeynames="id" Width="80%" DataSourceID="SqlDataManufacturers" OnSelect="gridManufacturers_Select" AllowAddingRecords="False"
            AutoPostBackOnSelect="true" AllowFiltering="false" OnDeleteCommand="gridManufacturers_DeleteCommand" OnUpdateCommand="gridManufacturers_UpdateCommand"
            FolderStyle="~/Styles/style_5"
            AllowGrouping="False" AllowRecordSelection="true" Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100">
            <ClientSideEvents OnBeforeClientDelete ="BeforeClientDelete"  />
            <columns>              
              
                <cc1:Column AllowEdit="true" AllowDelete="false" HeaderText="" Width="60px" runat="server" Index="0" />
                <cc1:Column AllowEdit="false" AllowDelete="true" HeaderText="" Width="60px" runat="server" Index="1" />
                <cc1:Column DataField="id" HeaderText="Id" Index="2" ReadOnly="True" Width="5px" Visible="false"></cc1:Column>
                <cc1:Column DataField="Manufacturer" HeaderText="Manufacturer" Index="3" Width="70%"  ></cc1:Column>
                <cc1:Column DataField="Models" HeaderText="Models" Index="4" Width="10%" AllowEdit="False" ReadOnly="True"></cc1:Column>
                <cc1:Column DataField="Repairs" HeaderText="Repairs" Index="5" Width="10%" AllowEdit="False" ReadOnly="True" ></cc1:Column>
               
             </columns>
         </cc1:Grid>
        
        <asp:SqlDataSource ID="SqlDataManufacturers" runat="server"  ConnectionString="<%$ ConnectionStrings:PirTickets %>" 
            SelectCommand="select man.id, man.manufacturer as Manufacturer,(select count(*) from models mods where mods.manufacturerID = man.id ) as Models, (select count(*) from RepairData where RepairData.ManufacturerName = man.id) as Repairs from manufacturers man order by [manufacturer]" >
        </asp:SqlDataSource>
        <br /><hr/>
        <h2>Models <asp:Label runat="server" ID="lblManufacturer"></asp:Label></h2>
        <h4>Add New Model</h4>
        <asp:TextBox ID="txtAddModel" runat="server" MaxLength="50" Width="220px"></asp:TextBox>
        <asp:Button ID="btAddModel" runat="server" onclick="baddModel_Click" Text="Add New" />
        <asp:Label ID="lblModel" runat="server"></asp:Label>
        <br />
        <cc1:Grid ID="gridModels" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="modelid"
            Width="80%" DataSourceID="SqlDataModels" AllowAddingRecords="False"
            AutoPostBackOnSelect="true" AllowFiltering="True" OnDeleteCommand="gridModels_DeleteCommand" OnUpdateCommand="gridModels_UpdateCommand" FolderStyle="~/Styles/style_5"
            AllowGrouping="False" AllowRecordSelection="true" Serialize="False" PageSize="20" PageSizeOptions="10,20,50,100">
            <ClientSideEvents OnBeforeClientDelete="BeforeClientDeleteModel" />
            <Columns>
                <cc1:Column DataField="modelid" HeaderText="Id" InsertVisible="False" Visible="false" Index="0" ReadOnly="True" SortExpression="modelid" Width="50px"></cc1:Column>
                <cc1:Column ID="Column1" AllowEdit="true" AllowDelete="false" HeaderText="" Width="60px" runat="server" Index="1" />
                <cc1:Column ID="Column2" AllowEdit="false" AllowDelete="true" HeaderText="" Width="60px" runat="server" Index="2" />
                <cc1:Column DataField="ModelName" HeaderText="Model Name" Index="3" SortExpression="ModelName" Width="70%">
                </cc1:Column>
            </Columns>
        </cc1:Grid>
</div>
        <asp:SqlDataSource ID="SqlDataModels" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>" 
            SelectCommand="SELECT [modelid], [ModelName] FROM [Models] WHERE ([manufacturerID] = @manufacturerID)" >
            <SelectParameters>
                <asp:Parameter  Name="manufacturerID" Type="Int32" />
            </SelectParameters>
        </asp:SqlDataSource>
    </ContentTemplate></asp:UpdatePanel>

    
</asp:Content>
