﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="Employee_List.aspx.cs" Inherits="PirTickets.Employee_List" %>

<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">
        <h1>Employee List</h1>
        <br />

        <cc2:OboutButton ID="btAdd" runat="server" Text="New Employee" OnClick="btAdd_Click"></cc2:OboutButton>
        <br />
        <br />

        <cc1:Grid ID="gridEmployees" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="EmployeeID"
            Width="70%" DataSourceID="SqlDataEmployees" OnSelect="gridEmployees_Select" AllowAddingRecords="False"
            AutoPostBackOnSelect="true" AllowFiltering="True" FolderStyle="~/Styles/style_5">
            <Columns>
                <cc1:Column DataField="EmployeeID" HeaderText="ID" SortExpression="EmployeeID" Index="0" Visible="false" Width="100px"></cc1:Column>
                <cc1:Column DataField="UserName" HeaderText="User Name" SortExpression="UserName" Index="1" Width="100%" />
                <cc1:Column DataField="name" HeaderText="name" SortExpression="name" Index="2" Width="100%" />
                <cc1:Column DataField="sitename" HeaderText="sitename" ReadOnly="True" SortExpression="sitename" Index="3" Width="100%" />

                <cc1:Column DataField="security_level_description" HeaderText="Security Level" ReadOnly="True" SortExpression="security_level_description" Index="5" Width="150%" />
            </Columns>
        </cc1:Grid>
    </div>
    <asp:SqlDataSource ID="SqlDataEmployees" runat="server"
        ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT [EmployeeID], [UserName], [name], [sitename], [security_level_description] FROM [vwEmployees]"></asp:SqlDataSource>
</asp:Content>
