﻿<%@ Page Title="Edit Employee" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="Employee_Edit.aspx.cs" Inherits="PirTickets.Employee_Edit" %>

<%@ Register Assembly="System.Web.DataVisualization, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI.DataVisualization.Charting" TagPrefix="asp" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc2" %>

<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
    <style type="text/css">
        .style3 {
            width: 460px;
        }

        .style4 {
            width: 494px;
        }

        .style6 {
            width: 145px;
        }

        .style7 {
            width: 169px;
        }

        .style8 {
            width: 137px;
        }

        .style9 {
        }

        .style10 {
            width: 174px;
        }

        .style11 {
            width: 219px;
        }

        .auto-style1 {
            width: 667px;
        }

        .auto-style2 {
            width: 457px;
        }

        .auto-style3 {
            width: 983px;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">
        <table cellpadding="2" border="0">
            <tr>
                <td colspan="4">
                    <asp:Label ID="lblheader" runat="server"></asp:Label></td>
            </tr>
            <tr>
                <td class="style8">Employee ID:</td>
                <td><span style="color: red;"></span></td>
                <td class="style9">
                    <asp:Label ID="lblEmpId" runat="server" Font-Bold="True"></asp:Label>
                </td>
                <td></td>
                <td>
                    <asp:ValidationSummary ID="ValidationSummary2" runat="server" ValidationGroup="a" />
                </td>
            </tr>
            <tr>
                <td class="style8">Username:</td>
                <td>&nbsp;</td>
                <td class="style9" colspan="2">
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                        <ContentTemplate>
                            <asp:TextBox ID="txtUsername" runat="server" MaxLength="50"
                                OnTextChanged="txtUsername_TextChanged" Width="230px" AutoPostBack="True"></asp:TextBox>
                            <asp:Label ID="lblExists" runat="server"></asp:Label>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ControlToValidate="txtUsername"
                                ErrorMessage="User Name is Required" ValidationGroup="a"></asp:RequiredFieldValidator>
                            <asp:UpdateProgress ID="UpdateProgress1" runat="server"
                                AssociatedUpdatePanelID="UpdatePanel1" DisplayAfter="100">
                            </asp:UpdateProgress>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
                <td>
                    <asp:Button ID="BtnUpdate" runat="server" Text="Save" OnClick="BtnUpdate_Click" CausesValidation="true" UseSubmitBehavior="true" ValidationGroup="a" Width="80px" />
                    <asp:Button ID="BtnCancel" CausesValidation="false" runat="server" Text="Cancel" OnClick="BtnCancel_Click" Width="80px" />
                    <asp:Button ID="bDelete" runat="server" OnClick="bDelete_Click" Text="Delete" CausesValidation="false" Width="80px" />
                </td>
            </tr>


        </table>

        <asp:TabContainer ID="TabContainer1" runat="server" ActiveTabIndex="0" TabStripPlacement="Top">
            <asp:TabPanel ID="tpDetail" runat="server" HeaderText="Details">
                <ContentTemplate>
                    <div class="well">
                        <table>
                            <tr>
                                <td class="style7">Title:</td>
                                <td></td>
                                <td class="style6">
                                    <asp:TextBox ID="TxtTitle" runat="server" MaxLength="20" Width="82px" /></td>
                                <td class="style1"></td>
                            </tr>
                            <tr>
                                <td class="style7">First Name:</td>
                                <td><span
                                    style="color: red;">*</span></td>
                                <td class="style6">
                                    <asp:TextBox ID="TxtFirstName" runat="server" MaxLength="50" /></td>
                                <td
                                    class="style1">
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtFirstName"
                                        ErrorMessage="First Name is Required" ValidationGroup="a"></asp:RequiredFieldValidator></td>
                            </tr>
                            <tr>
                                <td
                                    class="style7">Middle Name:</td>
                                <td></td>
                                <td class="style6">
                                    <asp:TextBox ID="TxtMiddleName" runat="server" MaxLength="30" Width="145px" /></td>
                                <td
                                    class="style1"></td>
                            </tr>
                            <tr>
                                <td class="style7">Last Name:</td>
                                <td><span style="color: red;">*</span></td>
                                <td class="style6">
                                    <asp:TextBox
                                        ID="TxtLastName" runat="server" MaxLength="50" Width="254px" /></td>
                                <td class="style1">
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2"
                                        runat="server" ControlToValidate="TxtLastName" ErrorMessage="Last Name is Required" ValidationGroup="a"></asp:RequiredFieldValidator></td>
                            </tr>
                            <tr>
                                <td class="style7">Security Level:</td>
                                <td><span style="color: red;">*</span></td>
                                <td class="style6">
                                    <asp:DropDownList ID="DDsecurity" runat="server" DataSourceID="SqlDataSourceSecurity" DataTextField="security_level_description"
                                        DataValueField="id">
                                    </asp:DropDownList><asp:SqlDataSource ID="SqlDataSourceSecurity" runat="server"
                                        ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                        SelectCommand="SELECT [id], [security_level_description] FROM [security_levels]"></asp:SqlDataSource>
                                </td>
                                <td
                                    class="style1"></td>
                            </tr>
                            <tr>
                                <td class="style7" valign="top">Location:</td>
                                <td>&nbsp;</td>
                                <td
                                    class="style6">
                                    <asp:DropDownList ID="ddSites" runat="server" DataSourceID="SqlDataSites" DataTextField="sitename" DataValueField="id"></asp:DropDownList>
                                    <asp:SqlDataSource ID="SqlDataSites" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
                                        SelectCommand="SELECT [id], [sitename] FROM [sites]"></asp:SqlDataSource>
                                </td>
                                <td
                                    class="style1">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="style7">Email:</td>
                                <td></td>
                                <td
                                    class="style6">
                                    <asp:TextBox ID="TxtEmailName" runat="server" MaxLength="50"
                                        Width="341px" /></td>
                                <td class="style1">
                                    <asp:RegularExpressionValidator
                                        ID="RegularExpressionValidator1" runat="server"
                                        ControlToValidate="TxtEmailName" ErrorMessage="Incorrect Format"
                                        ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"
                                        ValidationGroup="a"></asp:RegularExpressionValidator>

                                </td>
                            </tr>
                            <tr>
                                <td
                                    class="style7">Password:</td>
                                <td><span style="color: red;">*</span></td>
                                <td class="style6">
                                    <asp:TextBox ID="txtPassword" runat="server"></asp:TextBox>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ControlToValidate="txtPassword" ErrorMessage="Password Required" ValidationGroup="a"></asp:RequiredFieldValidator></td>
                                <td class="style1">&nbsp;</td>
                            </tr>
                            <tr>
                                <td class="style7">Confirm Password:</td>
                                <td>&nbsp;</td>
                                <td class="style6">
                                    <asp:TextBox ID="TxtPassConfirm" runat="server"></asp:TextBox>
                                    <asp:CompareValidator ID="CompareValidator1" runat="server" ControlToCompare="txtPassword" ControlToValidate="TxtPassConfirm" ErrorMessage="Passwords don't match" ValidationGroup="a"></asp:CompareValidator></td>
                                <td class="style1">&nbsp;</td>
                            </tr>
                        </table>
                    </div>
                </ContentTemplate>
            </asp:TabPanel>

            <asp:TabPanel ID="tpAddress" runat="server" HeaderText="Contact Details">
                <ContentTemplate>
                    <div class="well">

                        <table style="height: 417px; width: 707px">
                            <tr>
                                <td class="auto-style2">Address:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtAddress" runat="server" MaxLength="255" Width="231px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">City:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtCity" runat="server" MaxLength="50" Width="225px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">State:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtState" runat="server" MaxLength="50" Width="165px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Region:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtRegion" runat="server" MaxLength="50" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Postal Code:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtPostalCode" runat="server" MaxLength="20" Width="92px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Country:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtCountry" runat="server" MaxLength="50" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Home Phone:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtHomePhone" runat="server" MaxLength="30" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Work Phone:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtWorkPhone" runat="server" MaxLength="30" />&nbsp;Extension: 
            <asp:TextBox ID="TxtExtension" runat="server" MaxLength="30" Width="73px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Department Name:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtDepartmentName" runat="server" MaxLength="50" Width="306px" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Birthdate:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtBirthdate" runat="server" MaxLength="23" /></td>
                                <td></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Emergency Contact Name:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtEmrgcyContactName" runat="server" MaxLength="50" Width="291px" /></td>
                                <td rowspan="4"></td>
                            </tr>
                            <tr>
                                <td class="auto-style2">Emergency Contact Phone:</td>
                                <td class="auto-style3">
                                    <asp:TextBox ID="TxtEmrgcyContactPhone" runat="server" MaxLength="30" /></td>
                            </tr>
                        </table>
                    </div>
                </ContentTemplate>

            </asp:TabPanel>

            <asp:TabPanel ID="tpRepairs" runat="server" HeaderText="Repairs in Progress">
                <ContentTemplate>

                    <cc2:Grid ID="gridRepairs" runat="server" AllowPaging="True"
                        AllowSorting="True" AutoGenerateColumns="False" DataKeyNames="OrderID" DataSourceID="SqlDatacompleterepairs"
                        EmptyDataText="No Repairs for this Employee" OnSelect="gridRepairs_SelectedIndexChanged"
                        Width="80%" AutoPostBackOnSelect="true" AllowFiltering="False" FolderStyle="~/Styles/style_5">
                        <Columns>
                            <cc2:Column DataField="OrderID" HeaderText="ID" ReadOnly="True" SortExpression="OrderID" Width="80px" />
                            <cc2:Column DataField="manufacturer" HeaderText="Manufacturer" SortExpression="manufacturer" Width="100%" />
                            <cc2:Column DataField="ModelName" HeaderText="Model" SortExpression="ModelName" Width="100%" />
                            <cc2:Column DataField="Received" HeaderText="Received" ReadOnly="True" SortExpression="Received" Width="80px" />
                            <cc2:Column DataField="priority_name" HeaderText="Priority" SortExpression="priority_name" Width="80%" />
                            <cc2:Column DataField="status_name" HeaderText="Status" SortExpression="status_name" Width="80%" />
                            <cc2:Column DataField="SerialNumber" HeaderText="Serial" SortExpression="SerialNumber" Width="80px" />
                            <cc2:CheckBoxColumn DataField="UneconomicalToRepair" HeaderText="BER" SortExpression="UneconomicalToRepair" Width="80px" />
                            <cc2:Column DataField="externalref" HeaderText="Ref" SortExpression="externalref" Width="80px" />
                        </Columns>
                    </cc2:Grid>
                    </div>
               
                </ContentTemplate>
            </asp:TabPanel>
            <asp:TabPanel ID="tpComplete" runat="server" HeaderText="Repairs Completed">
                <ContentTemplate>

                    <cc2:Grid ID="gridCompleted" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False"
                        DataKeyNames="OrderID" DataSourceID="SqlDataRepairsinProgress"
                        EmptyDataText="No Repairs for this Employee" OnSelect="gridCompleted_Select"
                        Width="80%" AutoPostBackOnSelect="true" AllowFiltering="False" FolderStyle="~/Styles/style_5">
                        <Columns>
                            <cc2:Column DataField="OrderID" HeaderText="ID" ReadOnly="True" SortExpression="OrderID" Width="80px" />
                            <cc2:Column DataField="manufacturer" HeaderText="Manufacturer" SortExpression="manufacturer" Width="100%" />
                            <cc2:Column DataField="ModelName" HeaderText="Model" SortExpression="ModelName" Width="100%" />
                            <cc2:Column DataField="Received" HeaderText="Received" ReadOnly="True" SortExpression="Received" Width="80px" />
                            <cc2:Column DataField="priority_name" HeaderText="Priority" SortExpression="priority_name" Width="80%" />
                            <cc2:Column DataField="status_name" HeaderText="Status" SortExpression="status_name" Width="80%" />
                            <cc2:Column DataField="SerialNumber" HeaderText="Serial" SortExpression="SerialNumber" Width="80px" />
                            <cc2:CheckBoxColumn DataField="UneconomicalToRepair" HeaderText="BER" SortExpression="UneconomicalToRepair" Width="80px" />
                            <cc2:Column DataField="externalref" HeaderText="Ref" SortExpression="externalref" Width="80px" />
                        </Columns>
                    </cc2:Grid>
                    </div>
                         
                </ContentTemplate>
            </asp:TabPanel>
            <asp:TabPanel ID="tpCharts" runat="server" HeaderText="Performance Charts">
                <ContentTemplate>
                    <table>
                        <tr>
                            <td>
                                <asp:Chart ID="RChartPerf" runat="server" Width="739px" Palette="BrightPastel" BackColor="#D3DFF0"
                                    BorderlineDashStyle="Solid" BackGradientStyle="TopBottom" BorderWidth="2" BorderColor="26, 59, 105">
                                    <Titles>
                                        <asp:Title ShadowColor="32, 0, 0, 0" Font="Trebuchet MS, 14.25pt, style=Bold" ShadowOffset="3" Text="Repairs completed by month" ForeColor="26, 59, 105"></asp:Title>
                                    </Titles>
                                    <BorderSkin SkinStyle="Emboss"></BorderSkin>
                                    <Series>
                                        <asp:Series Name="Repairs" Legend="Legend1">
                                        </asp:Series>
                                    </Series>
                                    <ChartAreas>
                                        <asp:ChartArea Name="ChartArea1" BorderColor="64, 64, 64, 64" BackSecondaryColor="Transparent" BackColor="64, 165, 191, 228" ShadowColor="Transparent" BackGradientStyle="TopBottom">
                                            <Area3DStyle Rotation="10" Perspective="0" Enable3D="True" Inclination="5" IsRightAngleAxes="False" WallWidth="0" IsClustered="False" />
                                            <AxisY LineColor="64, 64, 64, 64">
                                                <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                <MajorGrid LineColor="64, 64, 64, 64" />
                                            </AxisY>
                                            <AxisX LineColor="64, 64, 64, 64">
                                                <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                <MajorGrid LineColor="64, 64, 64, 64" />
                                            </AxisX>
                                        </asp:ChartArea>
                                    </ChartAreas>
                                    <Legends>
                                        <asp:Legend Name="Legend1" Title="Repairs" BackColor="Transparent" Font="Trebuchet MS, 8.25pt, style=Bold">
                                        </asp:Legend>
                                    </Legends>
                                </asp:Chart>

                            </td>

                        </tr>
                        <tr>
                            <td>


                                <asp:Chart ID="RCPerf" runat="server" Width="739px" Palette="BrightPastel" BackColor="#D3DFF0"
                                    BorderlineDashStyle="Solid" BackGradientStyle="TopBottom" BorderWidth="2" BorderColor="26, 59, 105">
                                    <Titles>
                                        <asp:Title ShadowColor="32, 0, 0, 0" Font="Trebuchet MS, 14.25pt, style=Bold" ShadowOffset="3" Text="Repairs completed on time by month" ForeColor="26, 59, 105"></asp:Title>
                                    </Titles>
                                    <BorderSkin SkinStyle="Emboss"></BorderSkin>
                                    <Series>
                                        <asp:Series Name="Repairs" Legend="Legend1">
                                        </asp:Series>
                                    </Series>
                                    <ChartAreas>
                                        <asp:ChartArea Name="ChartArea1" BorderColor="64, 64, 64, 64" BackSecondaryColor="Transparent" BackColor="64, 165, 191, 228" ShadowColor="Transparent" BackGradientStyle="TopBottom">
                                            <Area3DStyle Rotation="10" Perspective="0" Enable3D="True" Inclination="5" IsRightAngleAxes="False" WallWidth="0" IsClustered="False" />
                                            <AxisY LineColor="64, 64, 64, 64">
                                                <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                <MajorGrid LineColor="64, 64, 64, 64" />
                                            </AxisY>
                                            <AxisX LineColor="64, 64, 64, 64">
                                                <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                <MajorGrid LineColor="64, 64, 64, 64" />
                                            </AxisX>
                                        </asp:ChartArea>
                                    </ChartAreas>
                                    <Legends>
                                        <asp:Legend Name="Legend1" Title="Repairs" BackColor="Transparent" Font="Trebuchet MS, 8.25pt, style=Bold">
                                        </asp:Legend>
                                    </Legends>
                                </asp:Chart>
                            </td>
                        </tr>
                    </table>
                </ContentTemplate>
            </asp:TabPanel>
        </asp:TabContainer>

    </div>

    <asp:SqlDataSource ID="SqlDatacompleterepairs" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT [OrderID], [manufacturer], [ModelName], [priority_name], [Received], [SerialNumber], [status_name],[UneconomicalToRepair],[externalref] FROM [vwRepairsbyEmployees] WHERE (([AssignedTechnician] = @AssignedTechnician) AND ([RepairCompleted] is null or [RepairCompleted] = 0 ))">
        <SelectParameters>
            <asp:QueryStringParameter Name="AssignedTechnician" QueryStringField="empid" Type="Int32" />
        </SelectParameters>
    </asp:SqlDataSource>
    <asp:SqlDataSource ID="SqlDataRepairsinProgress" runat="server" ConnectionString="<%$ ConnectionStrings:PirTickets %>"
        SelectCommand="SELECT [OrderID], [manufacturer], [ModelName], [Received], [priority_name], [status_name], [SerialNumber],[UneconomicalToRepair],[externalref] FROM [vwRepairsbyEmployees] WHERE (([AssignedTechnician] = @AssignedTechnician) AND ([RepairCompleted] = @RepairCompleted)) ORDER BY [OrderID]">
        <SelectParameters>
            <asp:QueryStringParameter Name="AssignedTechnician" QueryStringField="empid"
                Type="Int32" />
            <asp:Parameter DefaultValue="true" Name="RepairCompleted" Type="Boolean" />
        </SelectParameters>
    </asp:SqlDataSource>
</asp:Content>
