﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Master/MasterPage.master" AutoEventWireup="true" CodeBehind="CustomerList.aspx.cs" Inherits="PirTickets.CustomerList" %>

<%@ Register Assembly="obout_Interface" Namespace="Obout.Interface" TagPrefix="cc2" %>

<%@ Register Assembly="obout_Grid_NET" Namespace="Obout.Grid" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="Head" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <div class="jumbotron">
        <h2>Customer List</h2>
        <br />
        <cc2:OboutButton ID="btAdd" runat="server" Text="New Customer" OnClick="OboutButton1_Click"></cc2:OboutButton>
        <br />
        <br />
        <cc1:Grid ID="gridCustomers" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="false" datakeynames="CustomerID"
            Width="100%" DataSourceID="SqlDataCustomers" OnSelect="gridCustomers_Select" AllowAddingRecords="False" PageSize="100" PageSizeOptions="10, 20, 50, 100, 200, 500"
            AutoPostBackOnSelect="true" AllowFiltering="True" FolderStyle="~/Styles/style_5">
            <Columns>
                <cc1:Column DataField="CustomerID" HeaderText="ID" SortExpression="OrderID" Index="0" Visible="false" Width="100px"></cc1:Column>
                <cc1:Column DataField="OrganizationName" HeaderText="OrganizationName" SortExpression="OrganizationName" Index="1" Width="100%" />
                <cc1:Column DataField="Username" HeaderText="Username" SortExpression="Username" Index="2" Width="80%" />
                <cc1:Column DataField="FirstName" HeaderText="FirstName" ReadOnly="True" SortExpression="FirstName" Index="3" Width="80%" />
                <cc1:Column DataField="LastName" HeaderText="LastName" ReadOnly="True" SortExpression="LastName" Index="4" Width="80%" />
                <cc1:Column DataField="City" HeaderText="City" ReadOnly="True" SortExpression="City" Index="5" Width="100%" />
                <cc1:CheckBoxColumn DataField="Trader" HeaderText="Trader" SortExpression="Trader" Index="6" Width="80px" />
            </Columns>
        </cc1:Grid>
        <asp:SqlDataSource ID="SqlDataCustomers" runat="server"
            ConnectionString="<%$ ConnectionStrings:PirTickets %>"
            SelectCommand="SELECT [CustomerID], [OrganizationName], [Username], [FirstName], [LastName], [City], [Trader] FROM [Customers] order by LastName"></asp:SqlDataSource>
    </div>
</asp:Content>
