<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/***************************************************************************
 *	PROJECT: ZokiSoft Smart Catalog
 *
 *	This program is a commercial software and any kind of using
 *	it must agree to ZokiSoft License Agreement.
 *
 *	This notice may not be removed from the code.
 *
 *	Copyright 2007-2008 ZokiSoft
 *	http://www.zokisoft.com/
 ***************************************************************************/

class Catalog_admin_model extends Model {


    function Catalog_admin_model()
    {
        // Call the Model constructor
        parent::Model();
    }


/*
*
*	Create custom config file/values on runtime.
*
*	@param - array of arrays. prototype: array ( array ( name => 'bar', value = 'foo' ), .. )
*	@param - force to write config to database, table `zok_option`
*
*/
	function MakeCustomConfig ( $aOption, $bDbWrite=false )
	{

		foreach ( $aOption as $aItem )
		{
			$aItem = array_values($aItem);

			$this->config->set_item( $aItem[0], $aItem[1] );
			if ( $bDbWrite)
			{
				$aItem[1] = trim($aItem[1]);
				$this->db->where('`zok_option`.`Name` = \'' . $aItem[0] . '\'');
				$this->db->update('`zok_option`', array( 'Value' => $aItem[1] ));
			}
		}

	}


/*
*
*	Completely delete post and all its files.
*
*	@param - post id
*
*	@return string
*
*/
    function DeletePostById( $iPostId )
	{

		$this->load->database();
		$this->config->load('config_catalog');

		$sPostPicPath = $this->config->item('post_pic_path');

// delete pictures
		$this->db->select('`Id`, `Pic`, `Ext`');
		$this->db->where('`PostId` = \'' . $iPostId . '\'');
		$rRes = $this->db->get('`zok_post_pic`');
		$sId = '';
		foreach( $rRes->result_array() as $aPic )
		{
			$sId .= $aPic['Id'] . ',';

			@unlink( $sPostPicPath . $iPostId . '/' . $aPic['Pic'] . $aPic['Ext'] );
			@unlink( $sPostPicPath . $iPostId . '/' . $aPic['Pic'] . '_thumb' . $aPic['Ext'] );
			@unlink( $sPostPicPath . $iPostId . '/' . $aPic['Pic'] . '_icon' . $aPic['Ext'] );
		}
		$sId .= '0';

		$this->db->where( '`Id` IN (' . $sId . ')');
		$this->db->delete('`zok_post_pic`');

// delete comments
		$this->db->where( '`PostId`=\'' . $iPostId . '\'');
		$this->db->delete('`zok_comment`');

// delete post
		@rmdir( $sPostPicPath . $iPostId );

		$this->db->where( '`Id`=\'' . $iPostId . '\'');
		$this->db->delete('`zok_post`');

// delete langs
		$this->db->where( '`PostId`=\'' . $iPostId . '\'');
		$this->db->delete('`zok_post_lang`');

// delete custom fields
		$this->db->where( '`PostId`=\'' . $iPostId . '\'');
		$this->db->delete('`zok_post_clang`');
		
		return true;

	}


/*
*
*	Completely delete user and all its instances.
*
*	@param - user id
*
*	@return string
*
*/
    function DeleteUserById( $iUserId )
	{

// delete all users posts
		$this->db->select('`Id`');
		$this->db->where('`UserId` = \'' . $iUserId . '\'');
		$rRes = $this->db->get('`zok_post`');
		foreach( $rRes->result_array() as $aPost )
		{
			$this->DeletePostById( $aPost['Id'] );
		}


// update comments owner to guest:
		$this->db->where( '`UserId`=\'' . $iUserId . '\'');
		$this->db->update( '`zok_comment`', array( 'UserId' => '0' ) );

// delete pics
		$this->db->select('`UserFolder`, `Pic`, `Ext`');
		$this->db->where('`Id` = \'' . $iUserId . '\'');
		$rRes = $this->db->get('`zok_user`');
		$aPic = $rRes->row_array();
		if ( !empty($aPic['Pic']) )
		{
			@unlink( $this->config->item('user_data_path') . $aPic['UserFolder'] . $aPic['Pic'] . $aPic['Ext'] );
			@unlink( $this->config->item('user_data_path') . $aPic['UserFolder'] . $aPic['Pic'] . '_icon'. $aPic['Ext'] );
		}


// delete user files
/*
		$this->db->select('`zok_file`.`File`, `zok_file`.`Ext`, `zok_user`.`UserFolder`');
		$this->db->join('`zok_user`', '`zok_user`.`Id` = `zok_file`.`UserId`');
		$this->db->where('`zok_file`.`UserId` = \'' . $iUserId . '\'');
		$rRes = $this->db->get('`zok_file`');
		$aFile = $rRes->row_array();
		if ( !empty($aFile['File']) )
		{
			@unlink( $this->config->item('user_data_path') . $aFile['UserFolder'] . $this->config->item('user_file_folder') . $aFile['File'] . $aFile['Ext'] );
		}
*/

// delete from zok_user_data
		$this->db->where( '`UserId`=\'' . $iUserId . '\'');
		$this->db->delete('`zok_user_data`');

// delete from zok_user_openid
		$this->db->where( '`UserId`=\'' . $iUserId . '\'');
		$this->db->delete('`zok_user_openid`');
		
// delete from zok_user
		$this->db->where( '`Id`=\'' . $iUserId . '\'');
		$this->db->delete('`zok_user`');

		return true;

	}


/*
*
*	Recursively delete category and all its instances.
*
*	@param - category id
*
*	@return string
*
*/
	function DeleteCategoryById( $iCategoryId )
	{

		$this->db->select('`BreadCramb`');
		$this->db->where('`Id` = \'' . $iCategoryId . ' \'');
		$rRes = $this->db->get('`zok_category`');
		$aBreadCramb = $rRes->row_array();
// it seems that this category already has been deleted :-)
		if ( empty($aBreadCramb['BreadCramb']) )
			return true;

		$this->db->select('`Id`');
		$this->db->where('`BreadCramb` LIKE \'' . $aBreadCramb['BreadCramb'] . '%\'');
		$rRes = $this->db->get('`zok_category`');

		foreach ( $rRes->result_array() as $aCategory )
		{

			$this->db->select('`Id`');
			$this->db->where('`CategoryId` = \'' . $aCategory['Id'] . '\'');
			$rRes2 = $this->db->get('`zok_post`');
			foreach ( $rRes2->result_array() as $aPost )
			{
				$this->DeletePostById( $aPost['Id'] );
			}

			$this->db->where('`Id` = \'' . $aCategory['Id'] . '\'');
			$this->db->delete('`zok_category`');

			$this->db->where('`CategoryId` = \'' . $aCategory['Id'] . '\'');
			$this->db->delete('`zok_category_lang`');

		}

		return true;
	}



/*
*
*	Delete comment and all it's childs
*
*	@param - comment id
*
*	@return string
*
*/
	function DeleteCommentBranchById( $iCommentId )
	{

		$sId = $iCommentId . ',';

		$this->db->select('`zok_comment`.`Id`');
		$this->db->where( '`ParentId` = \'' . $iCommentId . '\'');
		$rRes = $this->db->get('`zok_comment`');
		while ( 0 < $rRes->num_rows() )
		{

			$sLevelDown = '';
			foreach ( $rRes->result_array() as $aId )
				$sLevelDown .= $aId['Id'] . ',';


			$this->db->select('`zok_comment`.`Id`');
			$this->db->where( '`ParentId` IN (' . substr($sLevelDown,0,-1) . ')');
			$rRes = $this->db->get('`zok_comment`');


			$sId .= $sLevelDown;

		}


		$this->db->where( ' Id IN (' . substr($sId,0,-1) . ')');
		$this->db->delete('zok_comment');


		return true;
	}

}


/* End of file Catalog_admin_model.php */
/* Location: ./system/application/models/Catalog_admin_model.php */