<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/***************************************************************************
 *	PROJECT: ZokiSoft Smart Catalog
 *
 *	This program is a commercial software and any kind of using
 *	it must agree to ZokiSoft License Agreement.
 *
 *	This notice may not be removed from the code.
 *
 *	Copyright 2007-2008 ZokiSoft
 *	http://www.zokisoft.com/
 ***************************************************************************/

class Pagination
{
	var $iItemsPerPage = 1;
	var $iPage = 1;
	var $iItemsNumber = 0;
	var $sUrl;
	var $sUrlDelimiter;
	var $rLang = null;
	var $sSimpleLink = false;

	function SetParams($iItemsPerPage, $iItemsNumber, $iPage, $sUrl = '', $rLang, $sSimpleLink = false )
	{
		$this->rLang = $rLang;

		$this->sUrl = $sUrl;
		$this->sSimpleLink = $sSimpleLink;
		//$this->sUrlDelimiter = (strpos($this->sUrl, '?') === false) ? '?' : '&';
		$this->sUrlDelimiter = '/';

		$this->iItemsPerPage = (int) $iItemsPerPage;
		$this->iItemsNumber = (int) $iItemsNumber;
		$this->iPagesNumber = ceil($this->iItemsNumber / $this->iItemsPerPage);
		if(isset($iPage) && $iPage > 1)
		{
			$this->iPage = $iPage;
		}
	}

	function GetStart()
	{
		return $this->iItemsPerPage * ($this->iPage - 1);
	}

	function GeneratePageNateLine()
	{
		$this->aPageNate = array();

		if($this->iPage > 1)
		{
			$aFirst = array('label' => $this->rLang->line('pn_first'), 'page' => 1, 'url' => $this->GetUrl(1));
			$aPrev = array('label' => $this->rLang->line('pn_prev'), 'page' => $this->iPage - 1, 'url' => $this->GetUrl($this->iPage - 1));
			$this->aPageNate[] = $aFirst;
			$this->aPageNate[] = $aPrev;
		}

		for($i = 1; $i <= $this->iPagesNumber; $i++)
		{
			$aPage = array('label' => $i, 'page' => $i, 'url' => $this->GetUrl($i));
			$aPage['current'] = (bool) ($i == $this->iPage);
			$this->aPageNate[] = $aPage;
		}

		if(count($this->aPageNate) == 1)
		{
			$this->aPageNate = array();
		}

		if($this->iPage < $this->iPagesNumber)
		{
			$aNext = array('label' => $this->rLang->line('pn_next'), 'page' => $this->iPage + 1, 'url' => $this->GetUrl($this->iPage + 1));
			$aLast = array('label' => $this->rLang->line('pn_last'), 'page' => $this->iPagesNumber, 'url' => $this->GetUrl($this->iPagesNumber));
			$this->aPageNate[] = $aNext;
			$this->aPageNate[] = $aLast;
		}

		return $this->aPageNate;
	}

	function GetUrl($iNumber)
	{
// make simple link to index page
		if ( '1' == $iNumber && false != $this->sSimpleLink )
			return $this->sSimpleLink;
		else
			return $this->sUrl . $this->sUrlDelimiter . $iNumber;
	}
}

/* End of file Pagination.php */
/* Location: ./system/application/libraries/Pagination.php */