<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Catalog_Image_lib extends CI_Image_lib
{

	// Secirity image Vars
	var $si_height			= '40';			// Height of security image
	var $si_width			= '';			// Width of security image
	var $si_font_path		= '';			// Path to TrueType font
	var $si_font_size		= '20';			// Font size of security image
	var $si_font_depth		= '2';			// Font depth
	var $si_text			= 'zoka';		// Security image text

	// Private Vars
	var $rVirtualImage 		= '';
	var $sBackgroundColor	= '';

// --------------------------------------------------------------------


/**
* Produses sequrity image
*
* @access	public
* @return	image data
*/
	function security_image()
	{

		if ( $this->dynamic_output != TRUE )
		{
			return FALSE;
		}


		if ( ! file_exists($this->si_font_path))
		{
			$this->set_error('imglib_missing_font');
			return FALSE;
		}

		$this->si_width = 40 + strlen($this->si_text)*($this->si_font_size+5);
		if ( ! ($this->rVirtualImage = imagecreate( $this->si_width, $this->si_height ) ) )
		{
			return FALSE;
		}


// apply gradient effect
		$this->security_image_gradient();

// apply greed effect
		$this->security_image_greed();

// apply dot effect
		$this->security_image_dot();

// apply text
		$this->security_image_text();

//  Output the final image
		$this->security_image_output();


		return true;

	}


	function security_image_gradient()
	{
		if ( ! isset($this->rVirtualImage) )
			return false;

		for( $i = 0, $rd = rand(0, 100), $gr = rand(0, 100), $bl= rand(0, 100); $i <= $this->si_height; $i++ )
		{
			$sGround = imagecolorallocate($this->rVirtualImage, $rd+=2, $gr+=2, $bl+=2);
			imageline($this->rVirtualImage, 0, $i, $this->si_width, $i, $sGround);
		}

		$this->sBackgroundColor = $sGround;


		return true;
	}


	function security_image_greed()
	{

		if ( ! isset($this->rVirtualImage) )
			return false;

		for( $i = 0, $x = 0, $z = $this->si_width; $i < $this->si_width; $i++, $z -= $this->si_font_size, $x += $this->si_font_size )
		{
			imageline($this->rVirtualImage, $x, 0, $x+10, $this->si_height, $this->sBackgroundColor);
			imageline($this->rVirtualImage, $z, 0, $z-10, $this->si_height, $this->sBackgroundColor);
		}

		return true;
	}



	function security_image_dot()
	{

		if ( ! isset($this->rVirtualImage) )
			return false;

		for($i = 0; $i < $this->si_width; $i++)
		{
			imagesetpixel ( $this->rVirtualImage, rand(0, $this->si_width), rand(0, $this->si_height), imagecolorallocate($this->rVirtualImage, rand(0, 255), rand(0, 255), rand(0, 255)) );
		}

		return true;
	}


	function security_image_text()
	{

		if ( ! isset($this->rVirtualImage) )
			return false;

		$sColor = imagecolorallocate($this->rVirtualImage, rand(0, 255), rand(0, 255), rand(0, 255));

		for($i = 0, $sStrlen = strlen($this->si_text), $iX = floor(abs((($this->si_width-($this->si_font_size*$sStrlen))/2)-floor($this->si_font_size/2))); $i < $sStrlen; $i++, $iX +=$this->si_font_size)
		{

			$iAngle = rand(-8, 8);

			$iY = rand(floor($this->si_height/2)+floor($this->si_font_size/2), $this->si_height-floor($this->si_font_size/2));
			for( $j = 0; $j <= $this->si_font_depth; $j++ )
			{
				imagettftext( $this->rVirtualImage, $this->si_font_size, $iAngle, $iX++, $iY++, $sColor, $this->si_font_path, $this->si_text[$i] );
			}

			imagettftext( $this->rVirtualImage, $this->si_font_size, $iAngle, $iX, $iY, $this->sBackgroundColor, $this->si_font_path, $this->si_text[$i] );

		}

		return true;
	}


	function security_image_output( $bDestroyImage = 'true' )
	{

		if ( ! isset($this->rVirtualImage) )
			return false;

		header("Content-type: image/png");
		header('Content-Transfer-Encoding: binary');
		header('Last-Modified: ' . date('D, d M Y H:i:s', time()).' GMT');
//		imageinterlace($this->rVirtualImage, 1);
		imagepng($this->rVirtualImage);

		if ( $bDestroyImage )
			imagedestroy($this->rVirtualImage);

		return true;

	}

}

/* End of file Catalog_Image_lib.php */
/* Location: ./system/application/libraries/Catalog_Image_lib.php */