<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2006, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * CodeIgniter URL Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/url_helper.html
 */

// ------------------------------------------------------------------------

/**
 * This uri helper modified to automatically add language postix to any local urls
 *
 * @author		ZokiSoft Team
 * @link		http://zokisoft.com
 */

// ------------------------------------------------------------------------

/**
 * Site URL
 *
 * Create a local URL based on your basepath. Segments can be passed via the
 * first parameter either as a string or an array.
 *
 * @access	public
 * @param	string
 * @return	string
 */
if (! function_exists('site_url'))
{
	function site_url($uri = '')
	{
		$CI =& get_instance();
		if ( '' == @$CI->aSystemVar['cur_lang_postfix'] )
			return $CI->config->site_url($uri);
		else
			return $CI->config->site_url(trim($uri,'/').'/'.@$CI->aSystemVar['cur_lang_postfix']);
	}
}

// ------------------------------------------------------------------------

/**
 * Base URL
 *
 * Returns the "base_url" item from your config file
 *
 * @access	public
 * @param	boolean
 * @return	string
 */
if (! function_exists('base_url'))
{
	function base_url($bAddPostfix=false)
	{
		$CI =& get_instance();
		if ($bAddPostfix)
			return $CI->config->slash_item('base_url').@$CI->aSystemVar['cur_lang_postfix'];
		else
			return $CI->config->slash_item('base_url');
	}
}

/* End of file Catalog_url_helper.php */
/* Location: ./system/application/helpers/Catalog_url_helper.php */