<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 4.3.2 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2006, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * CodeIgniter Form Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/form_helper.html
 */

// ------------------------------------------------------------------------

/**
 * This form helper modified to automatically add language postix to any local urls
 *
 * @author		ZokiSoft Team
 * @link		http://zokisoft.com
 */

// ------------------------------------------------------------------------

/**
 * Form Declaration
 *
 * Creates the opening portion of the form.
 *
 * @access	public
 * @param	string	the URI segments of the form destination
 * @param	array	a key/value pair of attributes
 * @param	array	a key/value pair hidden data
 * @return	string
 */
if (! function_exists('form_open'))
{
	function form_open($action = '', $attributes = array(), $hidden = array())
	{
		$CI =& get_instance();

		if (strpos($action, '://') === FALSE)
		{
			if ( '' == @$CI->aSystemVar['cur_lang_postfix'] )
				$action = $CI->config->site_url($action);
			else
				$action = $CI->config->site_url(trim($action,'/').'/'.@$CI->aSystemVar['cur_lang_postfix']);
		}

		$form = '<form action="'.$action.'"';

		if ( ! isset($attributes['method']))
		{
			$form .= ' method="post"';
		}

		if (is_array($attributes) AND count($attributes) > 0)
		{
			foreach ($attributes as $key => $val)
			{
				$form .= ' '.$key.'="'.$val.'"';
			}
		}

		$form .= '>';

		if (is_array($hidden) AND count($hidden > 0))
		{
			$form .= form_hidden($hidden);
		}

		return $form;
	}
}

// ------------------------------------------------------------------------

/* End of file Catalog_form_helper.php */
/* Location: ./system/application/helpers/Catalog_form_helper.php */