<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Display RSS
 *
 */
class Rss extends Catalog_Controller
{

	var $dateSubmit		= '';
	var $cache_time		= 60;
	var $sCategory		= '';
	var $sLang			= '';
	var $iRssNum		= 10;
	var $sCategoryTitle	= '';
	var $sCategoryDesc	= '';

	/**
	 * Constructor
	 * @access protected
	 */
	function Rss()
	{
		parent::Catalog_Controller();

		$this->aHeaderVar['catalog_charset'] = $this->config->item('catalog_charset');

		$this->aSystemVar['template_viewer_root'] = $this->config->item('template_module_viewer');
		$this->aSystemVar['template_viewer_current'] = $this->config->item('template_viewer_rss');

		$this->cache_time = 60;
		$this->dateSubmit = time();

	}

	/**
	  *	description
	  *
	  *	@param
	  *	@return
	  *
	  */
	 function index($sCategory = '',$sLang='')
	 {
	 	$this->load->helper('xml');

		$this->sCategory = $sCategory;
		$this->sLang = $sLang;

		$aData['data'] = array();
		$aData['data'] = $this->_getRss($sCategory,$sLang);
		//print_r($aData['data']);exit;
		$this->load->view($this->aSystemVar['template_viewer_current'] . 'rss.xml', $aData );
	 }

	/**
	 *	description
	 *
	 *	@param
	 *	@return
	 *
	 */
	function _getRss()
	{

		$aCategory = array('Id'=>0);

		if(!empty($this->sCategory))
		{

			if (!empty($this->sLang))
				$sLangCond = ' AND `zok_category_lang`.`Lang`=\''.$this->sLang.'\'';
			else
				$sLangCond = '';

			$this->db->select('`zok_category`.*,`zok_category_lang`.`Title`,`zok_category_lang`.`Description`,`zok_category_lang`.`Keywords`');
			$this->db->join('`zok_category_lang`',' `zok_category`.`Id`=`zok_category_lang`.`CategoryId`'.$sLangCond,'left');
			$this->db->where('`zok_category`.`BaseName`=\''.$this->sCategory.'\'');
			$rRes = $this->db->get('`zok_category`');

			$aCategory = $rRes->row_array();

			if (empty($aCategory['Id']))
				show_404();
			
			if (empty($aCategory['Title']))
				$aCategory['Title']=$aCategory['BaseName'];

			$aCategory['Title'] = xml_convert($aCategory['Title']);
			$aCategory['Description'] = xml_convert($aCategory['Description']);

		}

		$aPosts = $this->Catalog_model->GetPostList('recent', $this->iRssNum,'', $aCategory['Id'],true,false,$this->sLang);

		if(empty($aPosts))
		{
			return false;
		}

		if(!empty($aCategory['Title']))
		{
			$this->sCategoryTitle = $aCategory['Title'] . ' - ';
		}

		if(!empty($aCategory['Description']))
		{
			$this->sCategoryDesc = ' ' . $aCategory['Description'] . ' ';
		}

		return $this->_wrapPostArray($aPosts);
	}

	/*
*
*	Wrap array with post with additional data
*
*/

	function _wrapPostArray($aPostArray = array())
	{

		if ( !is_array($aPostArray) )
			return array();

		$aWrapPostArray = array();

		foreach( $aPostArray as $aPost )
		{
			$aPost['PicUrl'] = '';
			if ( !empty($aPost['Pic']) && $this->Catalog_model->ext_file_exists( $this->config->item('base_dir') . $this->config->item('post_pic_url') . $aPost['Id'] . '/' . $aPost['Pic'] . $aPost['Ext'] ) )
			{
				$aPost['PicUrl'] = base_url() . $this->config->item('post_pic_url') . $aPost['Id'] . '/' . $aPost['Pic'] . '_icon' . $aPost['Ext'];
			}

			$aPost['Body'] = nl2br($aPost['Body']);

// show in snipet not more than 4 strings:
			$iPos = -1;
			$iBreakLine = 0;
			do
			{
				$iPos = strpos( $aPost['Snipet'], "\n", ($iPos+1) );
				$iBreakLine++;
			}
			while ( $iPos && 4 > $iBreakLine );

			if ( $iPos && $iBreakLine >= 4 ) $aPost['Snipet'] = substr( $aPost['Snipet'], 0, $iPos );

			// remove opened, but not closed html tags.
			// WARNING - this option shuld work only for news, because in posts html symbols like '<' and '>' replaces to &gt; and &lt;
			// TODO: make check for double and single tags. Now, string '<a href="">zxc<a href="">asd</a>' considered as normal because every single tag is closed ))
			if ( 'news' == $aPost['SubType'] )
				$aPost['Snipet'] = preg_replace("/(<[^>]+?)(<|$)/s", '$2', $aPost['Snipet']);

// ------------------------------------------------------------
			$aPost['Snipet'] = nl2br($aPost['Snipet']);

			// if no title - use basename instead
			if (empty($aPost['CategoryTitle']) && @$aPost['CategoryBaseName'])
				$aPost['CategoryTitle'] = $aPost['CategoryBaseName'];

			// convert date submit po proper time format
			$aPost['DateSubmit'] = date('r',strtotime($aPost['DateSubmit']));

			$aWrapPostArray[] = $aPost;
		}

		return $aWrapPostArray;
	}

}

/* End of file rss.php */
/* Location: ./system/application/controllers/rss.php */