<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/***************************************************************************
 *	PROJECT: ZokiSoft Smart Catalog
 *
 *	This program is a commercial software and any kind of using
 *	it must agree to ZokiSoft License Agreement.
 *
 *	This notice may not be removed from the code.
 *
 *	Copyright 2007-2008 ZokiSoft
 *	http://www.zokisoft.com/
 ***************************************************************************/

class Mailbox extends Catalog_Controller
{

	var $aHeaderVar = array();
	var $aFooterVar = array();
//	var $aSystemVar = array();

/*
*
*	Constructor
*
*/
	function Mailbox()
	{

		parent::Catalog_Controller();

		if ( !$this->bLogIn )
			redirect('user/login/' . str_replace('/', ':', $this->uri->uri_string()));

		$this->aHeaderVar['catalog_charset'] = $this->config->item('catalog_charset');

		$this->aSystemVar['template_viewer_root'] = $this->config->item('template_module_viewer');
		$this->aSystemVar['template_viewer_current'] = $this->config->item('template_viewer_mailbox');


	}


	function index()
	{

		redirect('mailbox/inbox');

	}


	function inbox( $sUserId = '' )
	{

		$this->aHeaderVar['page_title']= $this->lang->line('_inbox');


		if ( is_array( $aLetterId = $this->input->post('LetterId') ) )
		{

			$sId = '0';

			foreach($aLetterId as $iId)
				$sId .= ',' . $iId;

			$this->db->where('`zok_user_mailbox`.`Id` IN (' . $sId . ') AND `zok_user_mailbox`.`UserId` = \'' . $this->aSystemVar['current_user']['Id'] . '\'');
			$this->db->delete('`zok_user_mailbox`');
		}

		$aData['data'] = array();
// if this is admin - shame on you !
		if ( !empty($sUserId) && $this->Catalog_model->isAdmin() )
		{
			$this->db->where('`zok_user_mailbox`.`UserId` = \'' . (int)$sUserId . '\' AND `zok_user_mailbox`.`UserId` = `zok_user_mailbox`.`RecipientId`');
		}
		else
		{
			$this->db->where('`zok_user_mailbox`.`UserId` = \'' . $this->aSystemVar['current_user']['Id'] . '\' AND `zok_user_mailbox`.`UserId` = `zok_user_mailbox`.`RecipientId`');
		}
		$this->db->select('`zok_user_mailbox`.*, `zok_user`.`Name` as SenderName');
		$this->db->join('`zok_user`', ' `zok_user`.`Id` = `zok_user_mailbox`.`SenderId`');

		$rRes = $this->db->get('`zok_user_mailbox`');

		$aData['data']['LetterList'] = $rRes->result_array();

		$this->load->view( $this->aSystemVar['template_viewer_current'] . 'inbox', $aData );

	}


	function outbox()
	{

		if ( is_array( $aLetterId = $this->input->post('LetterId') ) )
		{

			$sId = '0';

			foreach($aLetterId as $iId)
				$sId .= ',' . $iId;

			$this->db->where('`zok_user_mailbox`.`Id` IN (' . $sId . ') AND `zok_user_mailbox`.`UserId` = \'' . $this->aSystemVar['current_user']['Id'] . '\'');
			$this->db->delete('`zok_user_mailbox`');
		}

		$aData['data'] = array();

		$this->db->select('`zok_user_mailbox`.*, `zok_user`.`Name` as RecipientName');
		$this->db->join('`zok_user`', ' `zok_user`.`Id` = `zok_user_mailbox`.`RecipientId`');
		$this->db->where('`zok_user_mailbox`.`UserId` = \'' . $this->aSystemVar['current_user']['Id'] . '\' AND `zok_user_mailbox`.`UserId` = `zok_user_mailbox`.`SenderId`');
		$rRes = $this->db->get('`zok_user_mailbox`');

		$aData['data']['LetterList'] = $rRes->result_array();
		$this->aHeaderVar['page_title'] = $this->lang->line('_outbox');
		$this->load->view( $this->aSystemVar['template_viewer_current'] . 'outbox', $aData );

	}


	function compose( $iResipientId = '' )
	{


		$this->load->library('validation');

		if ( is_numeric($this->input->post('RecipientId')) )
		{

			$rules['Subject']	= "trim|required|xss_clean";
			$rules['Body']		= "trim|required|xss_clean";

			$this->validation->set_rules($rules);
			$this->validation->set_error_delimiters('<div class="error">', '</div>');

			if ($this->validation->run() == FALSE)
			{

				$aData['data']['Message']['Subject'] = $this->input->post('Subject');
				$aData['data']['Message']['Body'] = $this->input->post('Body');

				$aData['data']['Recipient'] = $this->Catalog_model->GetUserArrayById( $this->input->post('RecipientId') );

				$this->load->view( $this->aSystemVar['template_viewer_current'] . 'compose', $aData );

				return '';
			}
			else
			{

				$aData = array(	'UserId' => $this->input->post('RecipientId'),
								'SenderId' => $this->aSystemVar['current_user']['Id'],
								'RecipientId' => $this->input->post('RecipientId'),
								'Subject' => $this->input->post('Subject'),
								'Body' => htmlspecialchars($this->input->post('Body')),
								'DateSend' => date("Y-m-d H:i:s") );

// put into recipient's inbox
				$this->db->insert('`zok_user_mailbox`', $aData );

				$aData['UserId'] = $this->aSystemVar['current_user']['Id'];
				$aData['Status'] = 'read';

// put into sender outbox
				$this->db->insert('`zok_user_mailbox`', $aData );

				redirect('mailbox/outbox');

			}
		}

		if ( empty($iResipientId) || !is_numeric($iResipientId) )
			redirect('');

		$aData['data'] = array();
		$aData['data']['Recipient'] = $this->Catalog_model->GetUserArrayById($iResipientId);

		if ( empty($aData['data']['Recipient']['Id']) )
			redirect('');


		$aData['data']['Message'] = array( 	'Subject' => '',
												'Body' => '' );
		$this->aHeaderVar['page_title'] = $this->lang->line('_compose');
		$this->load->view( $this->aSystemVar['template_viewer_current'] . 'compose', $aData );

	}



}

/* End of file mailbox.php */
/* Location: ./system/application/controllers/mailbox.php */