-- 
-- Database: `catalog_pro`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_category`
-- 

CREATE TABLE `zok_category` (
  `Id` int(11) NOT NULL auto_increment,
  `ParentId` int(11) NOT NULL default '0',
  `BreadCramb` varchar(255) NOT NULL default '',
  `Pic` varchar(200) NOT NULL default '',
  `Ext` varchar(10) NOT NULL default '',
  `BaseName` varchar(60) NOT NULL default '',
  `CategoryOrder` int(2) NOT NULL default '0',
  `Status` enum('active','inactive','deleted') NOT NULL default 'inactive',
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `BaseName` (`BaseName`),
  KEY `ParentId` (`ParentId`),
  KEY `Status` (`Status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `zok_category`
-- 

INSERT INTO `zok_category` VALUES (1, 0, '0/1/', '', '', 'category-1', 1, 'active');
INSERT INTO `zok_category` VALUES (2, 0, '0/2/', '', '', 'category-2', 2, 'active');
INSERT INTO `zok_category` VALUES (3, 0, '0/3/', '', '', 'category-3', 3, 'active');
INSERT INTO `zok_category` VALUES (4, 1, '0/1/4/', '', '', 'category-4', 1, 'active');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_category_lang`
-- 

CREATE TABLE `zok_category_lang` (
  `Id` int(11) NOT NULL auto_increment,
  `CategoryId` int(11) NOT NULL default '0',
  `Lang` varchar(20) NOT NULL default '',
  `Title` varchar(255) NOT NULL default '',
  `Description` text NOT NULL,
  `Keywords` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`Id`),
  KEY `CategoryId` (`CategoryId`),
  KEY `Lang` (`Lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `zok_category_lang`
-- 

INSERT INTO `zok_category_lang` VALUES (1, 1, 'english', 'category 1', 'description of category 1', '');
INSERT INTO `zok_category_lang` VALUES (2, 2, 'english', 'category 2', 'description of category 2', '');
INSERT INTO `zok_category_lang` VALUES (3, 3, 'english', 'category 3', 'description of category 3', '');
INSERT INTO `zok_category_lang` VALUES (4, 4, 'english', 'category 4', 'description of category 4', '');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_comment`
-- 

CREATE TABLE `zok_comment` (
  `Id` int(11) NOT NULL auto_increment,
  `ParentId` int(11) NOT NULL default '0',
  `UserId` int(11) NOT NULL default '0',
  `PostId` int(11) NOT NULL default '0',
  `Body` text NOT NULL,
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `Status` enum('active','reported','deleted') NOT NULL default 'active',
  PRIMARY KEY  (`Id`),
  KEY `ParentId` (`ParentId`,`UserId`,`PostId`),
  KEY `Status` (`Status`),
  KEY `UserId` (`UserId`),
  KEY `PostId` (`PostId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_comment`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_country`
-- 

CREATE TABLE `zok_country` (
  `ISO2` varchar(2) NOT NULL default '',
  `ISO3` varchar(3) NOT NULL default '',
  `ISONo` smallint(3) NOT NULL default '0',
  `Country` varchar(100) NOT NULL default '',
  `Region` varchar(100) default NULL,
  `Currency` varchar(100) default NULL,
  `CurrencyCode` varchar(3) default NULL,
  PRIMARY KEY  (`ISO2`),
  KEY `CurrencyCode` (`CurrencyCode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Dumping data for table `zok_country`
-- 

INSERT INTO `zok_country` VALUES ('AD', 'AND', 20, 'Andorra', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('AE', 'ARE', 784, 'United Arab Emirates', 'Middle East', 'UAE Dirham', 'AED');
INSERT INTO `zok_country` VALUES ('AF', 'AFG', 4, 'Afghanistan', 'Asia', 'Afghani', 'AFA');
INSERT INTO `zok_country` VALUES ('AG', 'ATG', 28, 'Antigua and Barbuda', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('AI', 'AIA', 660, 'Anguilla', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('AL', 'ALB', 8, 'Albania', 'Europe', 'Lek', 'ALL');
INSERT INTO `zok_country` VALUES ('AM', 'ARM', 51, 'Armenia', 'Commonwealth of Independent States', 'Armenian Dram', 'AMD');
INSERT INTO `zok_country` VALUES ('AN', 'ANT', 530, 'Netherlands Antilles', 'Central America and the Caribbean', 'Netherlands Antillean guilder', 'ANG');
INSERT INTO `zok_country` VALUES ('AO', 'AGO', 24, 'Angola', 'Africa', 'Kwanza', 'AOA');
INSERT INTO `zok_country` VALUES ('AQ', 'ATA', 10, 'Antarctica', 'Antarctic Region', NULL, NULL);
INSERT INTO `zok_country` VALUES ('AR', 'ARG', 32, 'Argentina', 'South America', 'Argentine Peso', 'ARS');
INSERT INTO `zok_country` VALUES ('AS', 'ASM', 16, 'American Samoa', 'Oceania', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('AT', 'AUT', 40, 'Austria', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('AU', 'AUS', 36, 'Australia', 'Oceania', 'Australian dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('AW', 'ABW', 533, 'Aruba', 'Central America and the Caribbean', 'Aruban Guilder', 'AWG');
INSERT INTO `zok_country` VALUES ('AZ', 'AZE', 31, 'Azerbaijan', 'Commonwealth of Independent States', 'Azerbaijani Manat', 'AZM');
INSERT INTO `zok_country` VALUES ('BA', 'BIH', 70, 'Bosnia and Herzegovina', 'Bosnia and Herzegovina, Europe', 'Convertible Marka', 'BAM');
INSERT INTO `zok_country` VALUES ('BB', 'BRB', 52, 'Barbados', 'Central America and the Caribbean', 'Barbados Dollar', 'BBD');
INSERT INTO `zok_country` VALUES ('BD', 'BGD', 50, 'Bangladesh', 'Asia', 'Taka', 'BDT');
INSERT INTO `zok_country` VALUES ('BE', 'BEL', 56, 'Belgium', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('BF', 'BFA', 854, 'Burkina Faso', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('BG', 'BGR', 100, 'Bulgaria', 'Europe', 'Lev', 'BGL');
INSERT INTO `zok_country` VALUES ('BH', 'BHR', 48, 'Bahrain', 'Middle East', 'Bahraini Dinar', 'BHD');
INSERT INTO `zok_country` VALUES ('BI', 'BDI', 108, 'Burundi', 'Africa', 'Burundi Franc', 'BIF');
INSERT INTO `zok_country` VALUES ('BJ', 'BEN', 204, 'Benin', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('BM', 'BMU', 60, 'Bermuda', 'North America', 'Bermudian Dollar', 'BMD');
INSERT INTO `zok_country` VALUES ('BN', 'BRN', 96, 'Brunei Darussalam', 'Southeast Asia', 'Brunei Dollar', 'BND');
INSERT INTO `zok_country` VALUES ('BO', 'BOL', 68, 'Bolivia', 'South America', 'Boliviano', 'BOB');
INSERT INTO `zok_country` VALUES ('BR', 'BRA', 76, 'Brazil', 'South America', 'Brazilian Real', 'BRL');
INSERT INTO `zok_country` VALUES ('BS', 'BHS', 44, 'The Bahamas', 'Central America and the Caribbean', 'Bahamian Dollar', 'BSD');
INSERT INTO `zok_country` VALUES ('BT', 'BTN', 64, 'Bhutan', 'Asia', 'Ngultrum', 'BTN');
INSERT INTO `zok_country` VALUES ('BV', 'BVT', 74, 'Bouvet Island', 'Antarctic Region', 'Norwegian Krone', 'NOK');
INSERT INTO `zok_country` VALUES ('BW', 'BWA', 72, 'Botswana', 'Africa', 'Pula', 'BWP');
INSERT INTO `zok_country` VALUES ('BY', 'BLR', 112, 'Belarus', 'Commonwealth of Independent States', 'Belarussian Ruble', 'BYR');
INSERT INTO `zok_country` VALUES ('BZ', 'BLZ', 84, 'Belize', 'Central America and the Caribbean', 'Belize Dollar', 'BZD');
INSERT INTO `zok_country` VALUES ('CA', 'CAN', 124, 'Canada', 'North America', 'Canadian Dollar', 'CAD');
INSERT INTO `zok_country` VALUES ('CC', 'CCK', 166, 'Cocos (Keeling) Islands', 'Southeast Asia', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('CD', 'COD', 180, 'Congo, Democratic Republic of the', 'Africa', 'Franc Congolais', 'CDF');
INSERT INTO `zok_country` VALUES ('CF', 'CAF', 140, 'Central African Republic', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('CG', 'COG', 178, 'Congo, Republic of the', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('CH', 'CHE', 756, 'Switzerland', 'Europe', 'Swiss Franc', 'CHF');
INSERT INTO `zok_country` VALUES ('CI', 'CIV', 384, 'Cote d''Ivoire', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('CK', 'COK', 184, 'Cook Islands', 'Oceania', 'New Zealand Dollar', 'NZD');
INSERT INTO `zok_country` VALUES ('CL', 'CHL', 152, 'Chile', 'South America', 'Chilean Peso', 'CLP');
INSERT INTO `zok_country` VALUES ('CM', 'CMR', 120, 'Cameroon', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('CN', 'CHN', 156, 'China', 'Asia', 'Yuan Renminbi', 'CNY');
INSERT INTO `zok_country` VALUES ('CO', 'COL', 170, 'Colombia', 'South America, Central America and the Caribbean', 'Colombian Peso', 'COP');
INSERT INTO `zok_country` VALUES ('CR', 'CRI', 188, 'Costa Rica', 'Central America and the Caribbean', 'Costa Rican Colon', 'CRC');
INSERT INTO `zok_country` VALUES ('CU', 'CUB', 192, 'Cuba', 'Central America and the Caribbean', 'Cuban Peso', 'CUP');
INSERT INTO `zok_country` VALUES ('CV', 'CPV', 132, 'Cape Verde', 'World', 'Cape Verdean Escudo', 'CVE');
INSERT INTO `zok_country` VALUES ('CX', 'CXR', 162, 'Christmas Island', 'Southeast Asia', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('CY', 'CYP', 196, 'Cyprus', 'Middle East', 'Cyprus Pound', 'CYP');
INSERT INTO `zok_country` VALUES ('CZ', 'CZE', 203, 'Czech Republic', 'Europe', 'Czech Koruna', 'CZK');
INSERT INTO `zok_country` VALUES ('DE', 'DEU', 276, 'Germany', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('DJ', 'DJI', 262, 'Djibouti', 'Africa', 'Djibouti Franc', 'DJF');
INSERT INTO `zok_country` VALUES ('DK', 'DNK', 208, 'Denmark', 'Europe', 'Danish Krone', 'DKK');
INSERT INTO `zok_country` VALUES ('DM', 'DMA', 212, 'Dominica', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('DO', 'DOM', 214, 'Dominican Republic', 'Central America and the Caribbean', 'Dominican Peso', 'DOP');
INSERT INTO `zok_country` VALUES ('DZ', 'DZA', 12, 'Algeria', 'Africa', 'Algerian Dinar', 'DZD');
INSERT INTO `zok_country` VALUES ('EC', 'ECU', 218, 'Ecuador', 'South America', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('EE', 'EST', 233, 'Estonia', 'Europe', 'Kroon', 'EEK');
INSERT INTO `zok_country` VALUES ('EG', 'EGY', 818, 'Egypt', 'Africa', 'Egyptian Pound', 'EGP');
INSERT INTO `zok_country` VALUES ('EH', 'ESH', 732, 'Western Sahara', 'Africa', 'Moroccan Dirham', 'MAD');
INSERT INTO `zok_country` VALUES ('ER', 'ERI', 232, 'Eritrea', 'Africa', 'Nakfa', 'ERN');
INSERT INTO `zok_country` VALUES ('ES', 'ESP', 724, 'Spain', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('ET', 'ETH', 231, 'Ethiopia', 'Africa', 'Ethiopian Birr', 'ETB');
INSERT INTO `zok_country` VALUES ('FI', 'FIN', 246, 'Finland', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('FJ', 'FJI', 242, 'Fiji', 'Oceania', 'Fijian Dollar', 'FJD');
INSERT INTO `zok_country` VALUES ('FK', 'FLK', 238, 'Falkland Islands (Islas Malvinas)', 'South America', 'Falkland Islands Pound', 'FKP');
INSERT INTO `zok_country` VALUES ('FM', 'FSM', 583, 'Micronesia, Federated States of', 'Oceania', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('FO', 'FRO', 234, 'Faroe Islands', 'Europe', 'Danish Krone', 'DKK');
INSERT INTO `zok_country` VALUES ('FR', 'FRA', 250, 'France', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('GA', 'GAB', 266, 'Gabon', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('GB', 'GBR', 826, 'United Kingdom', 'Europe', 'Pound Sterling', 'GBP');
INSERT INTO `zok_country` VALUES ('GD', 'GRD', 308, 'Grenada', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('GE', 'GEO', 268, 'Georgia', 'Commonwealth of Independent States', 'Lari', 'GEL');
INSERT INTO `zok_country` VALUES ('GF', 'GUF', 254, 'French Guiana', 'South America', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('GH', 'GHA', 288, 'Ghana', 'Africa', 'Cedi', 'GHC');
INSERT INTO `zok_country` VALUES ('GI', 'GIB', 292, 'Gibraltar', 'Europe', 'Gibraltar Pound', 'GIP');
INSERT INTO `zok_country` VALUES ('GL', 'GRL', 304, 'Greenland', 'Arctic Region', 'Danish Krone', 'DKK');
INSERT INTO `zok_country` VALUES ('GM', 'GMB', 270, 'The Gambia', 'Africa', 'Dalasi', 'GMD');
INSERT INTO `zok_country` VALUES ('GN', 'GIN', 324, 'Guinea', 'Africa', 'Guinean Franc', 'GNF');
INSERT INTO `zok_country` VALUES ('GP', 'GLP', 312, 'Guadeloupe', 'Central America and the Caribbean', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('GQ', 'GNQ', 226, 'Equatorial Guinea', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('GR', 'GRC', 300, 'Greece', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('GS', 'SGS', 239, 'South Georgia and the South Sandwich Islands', 'Antarctic Region', 'Pound Sterling', 'GBP');
INSERT INTO `zok_country` VALUES ('GT', 'GTM', 320, 'Guatemala', 'Central America and the Caribbean', 'Quetzal', 'GTQ');
INSERT INTO `zok_country` VALUES ('GU', 'GUM', 316, 'Guam', 'Oceania', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('GW', 'GNB', 624, 'Guinea-Bissau', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('GY', 'GUY', 328, 'Guyana', 'South America', 'Guyana Dollar', 'GYD');
INSERT INTO `zok_country` VALUES ('HK', 'HKG', 344, 'Hong Kong (SAR)', 'Southeast Asia', 'Hong Kong Dollar', 'HKD');
INSERT INTO `zok_country` VALUES ('HM', 'HMD', 334, 'Heard Island and McDonald Islands', 'Antarctic Region', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('HN', 'HND', 340, 'Honduras', 'Central America and the Caribbean', 'Lempira', 'HNL');
INSERT INTO `zok_country` VALUES ('HR', 'HRV', 191, 'Croatia', 'Europe', 'Kuna', 'HRK');
INSERT INTO `zok_country` VALUES ('HT', 'HTI', 332, 'Haiti', 'Central America and the Caribbean', 'Gourde', 'HTG');
INSERT INTO `zok_country` VALUES ('HU', 'HUN', 348, 'Hungary', 'Europe', 'Forint', 'HUF');
INSERT INTO `zok_country` VALUES ('ID', 'IDN', 360, 'Indonesia', 'Southeast Asia', 'Rupiah', 'IDR');
INSERT INTO `zok_country` VALUES ('IE', 'IRL', 372, 'Ireland', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('IL', 'ISR', 376, 'Israel', 'Middle East', 'New Israeli Sheqel', 'ILS');
INSERT INTO `zok_country` VALUES ('IN', 'IND', 356, 'India', 'Asia', 'Indian Rupee', 'INR');
INSERT INTO `zok_country` VALUES ('IO', 'IOT', 86, 'British Indian Ocean Territory', 'World', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('IQ', 'IRQ', 368, 'Iraq', 'Middle East', 'Iraqi Dinar', 'IQD');
INSERT INTO `zok_country` VALUES ('IR', 'IRN', 364, 'Iran', 'Middle East', 'Iranian Rial', 'IRR');
INSERT INTO `zok_country` VALUES ('IS', 'ISL', 352, 'Iceland', 'Arctic Region', 'Iceland Krona', 'ISK');
INSERT INTO `zok_country` VALUES ('IT', 'ITA', 380, 'Italy', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('JM', 'JAM', 388, 'Jamaica', 'Central America and the Caribbean', 'Jamaican dollar', 'JMD');
INSERT INTO `zok_country` VALUES ('JO', 'JOR', 400, 'Jordan', 'Middle East', 'Jordanian Dinar', 'JOD');
INSERT INTO `zok_country` VALUES ('JP', 'JPN', 392, 'Japan', 'Asia', 'Yen', 'JPY');
INSERT INTO `zok_country` VALUES ('KE', 'KEN', 404, 'Kenya', 'Africa', 'Kenyan shilling', 'KES');
INSERT INTO `zok_country` VALUES ('KG', 'KGZ', 417, 'Kyrgyzstan', 'Commonwealth of Independent States', 'Som', 'KGS');
INSERT INTO `zok_country` VALUES ('KH', 'KHM', 116, 'Cambodia', 'Southeast Asia', 'Riel', 'KHR');
INSERT INTO `zok_country` VALUES ('KI', 'KIR', 296, 'Kiribati', 'Oceania', 'Australian dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('KM', 'COM', 174, 'Comoros', 'Africa', 'Comoro Franc', 'KMF');
INSERT INTO `zok_country` VALUES ('KN', 'KNA', 659, 'Saint Kitts and Nevis', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('KP', 'PRK', 408, 'Korea, North', 'Asia', 'North Korean Won', 'KPW');
INSERT INTO `zok_country` VALUES ('KR', 'KOR', 410, 'Korea, South', 'Asia', 'Won', 'KRW');
INSERT INTO `zok_country` VALUES ('KW', 'KWT', 414, 'Kuwait', 'Middle East', 'Kuwaiti Dinar', 'KWD');
INSERT INTO `zok_country` VALUES ('KY', 'CYM', 136, 'Cayman Islands', 'Central America and the Caribbean', 'Cayman Islands Dollar', 'KYD');
INSERT INTO `zok_country` VALUES ('KZ', 'KAZ', 398, 'Kazakhstan', 'Commonwealth of Independent States', 'Tenge', 'KZT');
INSERT INTO `zok_country` VALUES ('LA', 'LAO', 418, 'Laos', 'Southeast Asia', 'Kip', 'LAK');
INSERT INTO `zok_country` VALUES ('LB', 'LBN', 422, 'Lebanon', 'Middle East', 'Lebanese Pound', 'LBP');
INSERT INTO `zok_country` VALUES ('LC', 'LCA', 662, 'Saint Lucia', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('LI', 'LIE', 438, 'Liechtenstein', 'Europe', 'Swiss Franc', 'CHF');
INSERT INTO `zok_country` VALUES ('LK', 'LKA', 144, 'Sri Lanka', 'Asia', 'Sri Lanka Rupee', 'LKR');
INSERT INTO `zok_country` VALUES ('LR', 'LBR', 430, 'Liberia', 'Africa', 'Liberian Dollar', 'LRD');
INSERT INTO `zok_country` VALUES ('LS', 'LSO', 426, 'Lesotho', 'Africa', 'Loti', 'LSL');
INSERT INTO `zok_country` VALUES ('LT', 'LTU', 440, 'Lithuania', 'Europe', 'Lithuanian Litas', 'LTL');
INSERT INTO `zok_country` VALUES ('LU', 'LUX', 442, 'Luxembourg', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('LV', 'LVA', 428, 'Latvia', 'Europe', 'Latvian Lats', 'LVL');
INSERT INTO `zok_country` VALUES ('LY', 'LBY', 434, 'Libya', 'Africa', 'Libyan Dinar', 'LYD');
INSERT INTO `zok_country` VALUES ('MA', 'MAR', 504, 'Morocco', 'Africa', 'Moroccan Dirham', 'MAD');
INSERT INTO `zok_country` VALUES ('MC', 'MCO', 492, 'Monaco', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('MD', 'MDA', 498, 'Moldova', 'Commonwealth of Independent States', 'Moldovan Leu', 'MDL');
INSERT INTO `zok_country` VALUES ('MG', 'MDG', 450, 'Madagascar', 'Africa', 'Malagasy Franc', 'MGF');
INSERT INTO `zok_country` VALUES ('MH', 'MHL', 584, 'Marshall Islands', 'Oceania', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('MK', 'MKD', 807, 'Macedonia, The Former Yugoslav Republic of', 'Europe', 'Denar', 'MKD');
INSERT INTO `zok_country` VALUES ('ML', 'MLI', 466, 'Mali', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('MM', 'MMR', 104, 'Burma', 'Southeast Asia', 'kyat', 'MMK');
INSERT INTO `zok_country` VALUES ('MN', 'MNG', 496, 'Mongolia', 'Asia', 'Tugrik', 'MNT');
INSERT INTO `zok_country` VALUES ('MO', 'MAC', 446, 'Macao', 'Southeast Asia', 'Pataca', 'MOP');
INSERT INTO `zok_country` VALUES ('MP', 'MNP', 580, 'Northern Mariana Islands', 'Oceania', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('MQ', 'MTQ', 474, 'Martinique', 'Central America and the Caribbean', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('MR', 'MRT', 478, 'Mauritania', 'Africa', 'Ouguiya', 'MRO');
INSERT INTO `zok_country` VALUES ('MS', 'MSR', 500, 'Montserrat', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('MT', 'MLT', 470, 'Malta', 'Europe', 'Maltese Lira', 'MTL');
INSERT INTO `zok_country` VALUES ('MU', 'MUS', 480, 'Mauritius', 'World', 'Mauritius Rupee', 'MUR');
INSERT INTO `zok_country` VALUES ('MV', 'MDV', 462, 'Maldives', 'Asia', 'Rufiyaa', 'MVR');
INSERT INTO `zok_country` VALUES ('MW', 'MWI', 454, 'Malawi', 'Africa', 'Kwacha', 'MWK');
INSERT INTO `zok_country` VALUES ('MX', 'MEX', 484, 'Mexico', 'North America', 'Mexican Peso', 'MXN');
INSERT INTO `zok_country` VALUES ('MY', 'MYS', 458, 'Malaysia', 'Southeast Asia', 'Malaysian Ringgit', 'MYR');
INSERT INTO `zok_country` VALUES ('MZ', 'MOZ', 508, 'Mozambique', 'Africa', 'Metical', 'MZM');
INSERT INTO `zok_country` VALUES ('NA', 'NAM', 516, 'Namibia', 'Africa', 'Namibian Dollar', 'NAD');
INSERT INTO `zok_country` VALUES ('NC', 'NCL', 540, 'New Caledonia', 'Oceania', 'CFP Franc', 'XPF');
INSERT INTO `zok_country` VALUES ('NE', 'NER', 562, 'Niger', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('NF', 'NFK', 574, 'Norfolk Island', 'Oceania', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('NG', 'NGA', 566, 'Nigeria', 'Africa', 'Naira', 'NGN');
INSERT INTO `zok_country` VALUES ('NI', 'NIC', 558, 'Nicaragua', 'Central America and the Caribbean', 'Cordoba Oro', 'NIO');
INSERT INTO `zok_country` VALUES ('NL', 'NLD', 528, 'Netherlands', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('NO', 'NOR', 578, 'Norway', 'Europe', 'Norwegian Krone', 'NOK');
INSERT INTO `zok_country` VALUES ('NP', 'NPL', 524, 'Nepal', 'Asia', 'Nepalese Rupee', 'NPR');
INSERT INTO `zok_country` VALUES ('NR', 'NRU', 520, 'Nauru', 'Oceania', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('NU', 'NIU', 570, 'Niue', 'Oceania', 'New Zealand Dollar', 'NZD');
INSERT INTO `zok_country` VALUES ('NZ', 'NZL', 554, 'New Zealand', 'Oceania', 'New Zealand Dollar', 'NZD');
INSERT INTO `zok_country` VALUES ('OM', 'OMN', 512, 'Oman', 'Middle East', 'Rial Omani', 'OMR');
INSERT INTO `zok_country` VALUES ('PA', 'PAN', 591, 'Panama', 'Central America and the Caribbean', 'balboa', 'PAB');
INSERT INTO `zok_country` VALUES ('PE', 'PER', 604, 'Peru', 'South America', 'Nuevo Sol', 'PEN');
INSERT INTO `zok_country` VALUES ('PF', 'PYF', 258, 'French Polynesia', 'Oceania', 'CFP Franc', 'XPF');
INSERT INTO `zok_country` VALUES ('PG', 'PNG', 598, 'Papua New Guinea', 'Oceania', 'Kina', 'PGK');
INSERT INTO `zok_country` VALUES ('PH', 'PHL', 608, 'Philippines', 'Southeast Asia', 'Philippine Peso', 'PHP');
INSERT INTO `zok_country` VALUES ('PK', 'PAK', 586, 'Pakistan', 'Asia', 'Pakistan Rupee', 'PKR');
INSERT INTO `zok_country` VALUES ('PL', 'POL', 616, 'Poland', 'Europe', 'Zloty', 'PLN');
INSERT INTO `zok_country` VALUES ('PM', 'SPM', 666, 'Saint Pierre and Miquelon', 'North America', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('PN', 'PCN', 612, 'Pitcairn Islands', 'Oceania', 'New Zealand Dollar', 'NZD');
INSERT INTO `zok_country` VALUES ('PR', 'PRI', 630, 'Puerto Rico', 'Central America and the Caribbean', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('PS', 'PSE', 275, 'Palestinian Territory, Occupied', NULL, NULL, NULL);
INSERT INTO `zok_country` VALUES ('PT', 'PRT', 620, 'Portugal', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('PW', 'PLW', 585, 'Palau', 'Oceania', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('PY', 'PRY', 600, 'Paraguay', 'South America', 'Guarani', 'PYG');
INSERT INTO `zok_country` VALUES ('QA', 'QAT', 634, 'Qatar', 'Middle East', 'Qatari Rial', 'QAR');
INSERT INTO `zok_country` VALUES ('RE', 'REU', 638, 'Reunion', 'World', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('RO', 'ROU', 642, 'Romania', 'Europe', 'Leu', 'ROL');
INSERT INTO `zok_country` VALUES ('RU', 'RUS', 643, 'Russia', 'Asia', 'Russian Ruble', 'RUB');
INSERT INTO `zok_country` VALUES ('RW', 'RWA', 646, 'Rwanda', 'Africa', 'Rwanda Franc', 'RWF');
INSERT INTO `zok_country` VALUES ('SA', 'SAU', 682, 'Saudi Arabia', 'Middle East', 'Saudi Riyal', 'SAR');
INSERT INTO `zok_country` VALUES ('SB', 'SLB', 90, 'Solomon Islands', 'Oceania', 'Solomon Islands Dollar', 'SBD');
INSERT INTO `zok_country` VALUES ('SC', 'SYC', 690, 'Seychelles', 'Africa', 'Seychelles Rupee', 'SCR');
INSERT INTO `zok_country` VALUES ('SD', 'SDN', 736, 'Sudan', 'Africa', 'Sudanese Dinar', 'SDD');
INSERT INTO `zok_country` VALUES ('SE', 'SWE', 752, 'Sweden', 'Europe', 'Swedish Krona', 'SEK');
INSERT INTO `zok_country` VALUES ('SG', 'SGP', 702, 'Singapore', 'Southeast Asia', 'Singapore Dollar', 'SGD');
INSERT INTO `zok_country` VALUES ('SH', 'SHN', 654, 'Saint Helena', 'Africa', 'Saint Helenian Pound', 'SHP');
INSERT INTO `zok_country` VALUES ('SI', 'SVN', 705, 'Slovenia', 'Europe', 'Tolar', 'SIT');
INSERT INTO `zok_country` VALUES ('SJ', 'SJM', 744, 'Svalbard', 'Arctic Region', 'Norwegian Krone', 'NOK');
INSERT INTO `zok_country` VALUES ('SK', 'SVK', 703, 'Slovakia', 'Europe', 'Slovak Koruna', 'SKK');
INSERT INTO `zok_country` VALUES ('SL', 'SLE', 694, 'Sierra Leone', 'Africa', 'Leone', 'SLL');
INSERT INTO `zok_country` VALUES ('SM', 'SMR', 674, 'San Marino', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('SN', 'SEN', 686, 'Senegal', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('SO', 'SOM', 706, 'Somalia', 'Africa', 'Somali Shilling', 'SOS');
INSERT INTO `zok_country` VALUES ('SR', 'SUR', 740, 'Suriname', 'South America', 'Suriname Guilder', 'SRG');
INSERT INTO `zok_country` VALUES ('ST', 'STP', 678, 'Sao Tome and Principe', 'Africa', 'Dobra', 'STD');
INSERT INTO `zok_country` VALUES ('SV', 'SLV', 222, 'El Salvador', 'Central America and the Caribbean', 'El Salvador Colon', 'SVC');
INSERT INTO `zok_country` VALUES ('SY', 'SYR', 760, 'Syria', 'Middle East', 'Syrian Pound', 'SYP');
INSERT INTO `zok_country` VALUES ('SZ', 'SWZ', 748, 'Swaziland', 'Africa', 'Lilangeni', 'SZL');
INSERT INTO `zok_country` VALUES ('TC', 'TCA', 796, 'Turks and Caicos Islands', 'Central America and the Caribbean', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('TD', 'TCD', 148, 'Chad', 'Africa', 'CFA Franc BEAC', 'XAF');
INSERT INTO `zok_country` VALUES ('TF', 'ATF', 260, 'French Southern and Antarctic Lands', 'Antarctic Region', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('TG', 'TGO', 768, 'Togo', 'Africa', 'CFA Franc BCEAO', 'XOF');
INSERT INTO `zok_country` VALUES ('TH', 'THA', 764, 'Thailand', 'Southeast Asia', 'Baht', 'THB');
INSERT INTO `zok_country` VALUES ('TJ', 'TJK', 762, 'Tajikistan', 'Commonwealth of Independent States', 'Somoni', 'TJS');
INSERT INTO `zok_country` VALUES ('TK', 'TKL', 772, 'Tokelau', 'Oceania', 'New Zealand Dollar', 'NZD');
INSERT INTO `zok_country` VALUES ('TL', 'TLS', 626, 'East Timor', NULL, 'Timor Escudo', 'TPE');
INSERT INTO `zok_country` VALUES ('TM', 'TKM', 795, 'Turkmenistan', 'Commonwealth of Independent States', 'Manat', 'TMM');
INSERT INTO `zok_country` VALUES ('TN', 'TUN', 788, 'Tunisia', 'Africa', 'Tunisian Dinar', 'TND');
INSERT INTO `zok_country` VALUES ('TO', 'TON', 776, 'Tonga', 'Oceania', 'Pa''anga', 'TOP');
INSERT INTO `zok_country` VALUES ('TR', 'TUR', 792, 'Turkey', 'Middle East', 'Turkish Lira', 'TRL');
INSERT INTO `zok_country` VALUES ('TT', 'TTO', 780, 'Trinidad and Tobago', 'Central America and the Caribbean', 'Trinidad and Tobago Dollar', 'TTD');
INSERT INTO `zok_country` VALUES ('TV', 'TUV', 798, 'Tuvalu', 'Oceania', 'Australian Dollar', 'AUD');
INSERT INTO `zok_country` VALUES ('TW', 'TWN', 158, 'Taiwan', 'Southeast Asia', 'New Taiwan Dollar', 'TWD');
INSERT INTO `zok_country` VALUES ('TZ', 'TZA', 834, 'Tanzania', 'Africa', 'Tanzanian Shilling', 'TZS');
INSERT INTO `zok_country` VALUES ('UA', 'UKR', 804, 'Ukraine', 'Commonwealth of Independent States', 'Hryvnia', 'UAH');
INSERT INTO `zok_country` VALUES ('UG', 'UGA', 800, 'Uganda', 'Africa', 'Uganda Shilling', 'UGX');
INSERT INTO `zok_country` VALUES ('UM', 'UMI', 581, 'United States Minor Outlying Islands', NULL, 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('US', 'USA', 840, 'United States', 'North America', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('UY', 'URY', 858, 'Uruguay', 'South America', 'Peso Uruguayo', 'UYU');
INSERT INTO `zok_country` VALUES ('UZ', 'UZB', 860, 'Uzbekistan', 'Commonwealth of Independent States', 'Uzbekistan Sum', 'UZS');
INSERT INTO `zok_country` VALUES ('VA', 'VAT', 336, 'Holy See (Vatican City)', 'Europe', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('VC', 'VCT', 670, 'Saint Vincent and the Grenadines', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD');
INSERT INTO `zok_country` VALUES ('VE', 'VEN', 862, 'Venezuela', 'South America, Central America and the Caribbean', 'Bolivar', 'VEB');
INSERT INTO `zok_country` VALUES ('VG', 'VGB', 92, 'British Virgin Islands', 'Central America and the Caribbean', 'US dollar', 'USD');
INSERT INTO `zok_country` VALUES ('VI', 'VIR', 850, 'Virgin Islands', 'Central America and the Caribbean', 'US Dollar', 'USD');
INSERT INTO `zok_country` VALUES ('VN', 'VNM', 704, 'Vietnam', 'Southeast Asia', 'Dong', 'VND');
INSERT INTO `zok_country` VALUES ('VU', 'VUT', 548, 'Vanuatu', 'Oceania', 'Vatu', 'VUV');
INSERT INTO `zok_country` VALUES ('WF', 'WLF', 876, 'Wallis and Futuna', 'Oceania', 'CFP Franc', 'XPF');
INSERT INTO `zok_country` VALUES ('WS', 'WSM', 882, 'Samoa', 'Oceania', 'Tala', 'WST');
INSERT INTO `zok_country` VALUES ('YE', 'YEM', 887, 'Yemen', 'Middle East', 'Yemeni Rial', 'YER');
INSERT INTO `zok_country` VALUES ('YT', 'MYT', 175, 'Mayotte', 'Africa', 'Euro', 'EUR');
INSERT INTO `zok_country` VALUES ('YU', 'YUG', 891, 'Yugoslavia', 'Europe', 'Yugoslavian Dinar', 'YUM');
INSERT INTO `zok_country` VALUES ('ZA', 'ZAF', 710, 'South Africa', 'Africa', 'Rand', 'ZAR');
INSERT INTO `zok_country` VALUES ('ZM', 'ZWB', 894, 'Zambia', 'Africa', 'Kwacha', 'ZMK');
INSERT INTO `zok_country` VALUES ('ZW', 'ZWE', 716, 'Zimbabwe', 'Africa', 'Zimbabwe Dollar', 'ZWD');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_email_queue`
-- 

CREATE TABLE `zok_email_queue` (
  `Id` int(11) NOT NULL auto_increment,
  `Sender` varchar(64) NOT NULL default '',
  `Recipient` varchar(64) NOT NULL default '',
  `Subject` varchar(255) NOT NULL default '',
  `Body` mediumtext NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_email_queue`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_email_template`
-- 

CREATE TABLE `zok_email_template` (
  `Id` int(11) NOT NULL auto_increment,
  `Name` varchar(32) NOT NULL default '',
  `Description` varchar(255) NOT NULL default '',
  `Subject` varchar(64) NOT NULL default '',
  `Body` mediumtext NOT NULL,
  `SpecialVar` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

-- 
-- Dumping data for table `zok_email_template`
-- 

INSERT INTO `zok_email_template` VALUES (1, 'confirm_email', 'Email to confirm newbie email', 'Confirmation mail', 'This is confirmation mail\nYour confirmation code is "__confirmation_code__"\nTo confirm your account just follow this link:\n__confirmation_code_link__', '''confirmation_code'',''confirmation_code_link'',''user_name''');
INSERT INTO `zok_email_template` VALUES (2, 'forget_password', 'Email to restore user password', 'Password restore letter', '__site_title__\n__user_nick__,\nYou ( or someone else ))) has reset your password to site __site_title__\nNew password is "__new_password__".\nYou can change it to any you like within your account.\n', '''user_nick'',''new_password''');
INSERT INTO `zok_email_template` VALUES (3, 'contact_author', 'Email to contact author', 'Contact letter', '__user_message__', '''user_message''');
INSERT INTO `zok_email_template` VALUES (4, 'registration', 'Email with congratulation about success registration', 'Registration complete', 'Dear __user_nick__,\r\n\r\nGlad to inform you that registration to __site_title__ successfully passed with next information.\r\n\r\n============\r\n\r\nLogin:		__user_nick__\r\nPassword:	__user_password__\r\nE-mail:		__user_email__\r\n\r\n============\r\n\r\nYou also can login with same login and password to our forum.\r\n\r\n----\r\n__site_title__ Administration team.\r\n\r\n', '''user_nick'',''user_login'',''user_password'',''user_email''');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_lang`
-- 

CREATE TABLE `zok_lang` (
  `Id` int(11) NOT NULL auto_increment,
  `BaseName` varchar(100) NOT NULL default '',
  `Title` varchar(100) NOT NULL default '',
  `Def` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `BaseName` (`BaseName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `zok_lang`
-- 

INSERT INTO `zok_lang` VALUES (1, 'english', 'english', 1);

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_option`
-- 

CREATE TABLE `zok_option` (
  `Id` int(11) NOT NULL auto_increment,
  `Name` varchar(32) NOT NULL default '',
  `Value` text NOT NULL,
  `Range` varchar(64) default NULL,
  `Description` varchar(255) NOT NULL default '',
  `Type` enum('text','checkbox','select','textarea') NOT NULL default 'text',
  `Group` enum('user','post','category','catalog','index_page','ads') NOT NULL default 'catalog',
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=45 ;

-- 
-- Dumping data for table `zok_option`
-- 

INSERT INTO `zok_option` VALUES (29, 'comment_characters', '1000', 'NULL', 'Max limit of comment, characters', 'text', 'post');
INSERT INTO `zok_option` VALUES (2, 'premoderation', '0', 'NULL', 'Enable PreModeration', 'checkbox', 'catalog');
INSERT INTO `zok_option` VALUES (3, 'browse_mod', '1', 'NULL', 'Browse mode', 'checkbox', 'catalog');
INSERT INTO `zok_option` VALUES (7, 'security_code_length', '4', 'NULL', 'length of sequrity code', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (8, 'user_icon_width', '50', 'NULL', 'width of user icon', 'text', 'user');
INSERT INTO `zok_option` VALUES (9, 'user_icon_height', '50', 'NULL', 'height of user icon', 'text', 'user');
INSERT INTO `zok_option` VALUES (10, 'user_thumb_width', '100', 'NULL', 'user thumb width', 'text', 'user');
INSERT INTO `zok_option` VALUES (11, 'user_thumb_height', '100', 'NULL', 'user thumb height', 'text', 'user');
INSERT INTO `zok_option` VALUES (12, 'post_pic_num', '12', 'NULL', 'Number of allowed pics for post', 'text', 'post');
INSERT INTO `zok_option` VALUES (13, 'post_thumb_width', '250', 'NULL', 'Width of post thumb pics', 'text', 'post');
INSERT INTO `zok_option` VALUES (14, 'post_thumb_height', '250', 'NULL', 'Heigth of post thumb pics', 'text', 'post');
INSERT INTO `zok_option` VALUES (15, 'post_icon_width', '100', 'NULL', 'Width of post icon pics', 'text', 'post');
INSERT INTO `zok_option` VALUES (16, 'post_icon_height', '100', 'NULL', 'Heigth of post icon pics', 'text', 'post');
INSERT INTO `zok_option` VALUES (17, 'pagination_item_per_page', '10', 'NULL', 'Pagination: items per page', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (18, 'newbie_status', 'inactive', '''active'',''inactive''', 'Newbie user status', 'select', 'user');
INSERT INTO `zok_option` VALUES (19, 'confirmation_mail', '1', 'NULL', 'Send confirmation mail', 'checkbox', 'user');
INSERT INTO `zok_option` VALUES (20, 'security_code', '0', 'NULL', 'Enable security images', 'checkbox', 'catalog');
INSERT INTO `zok_option` VALUES (22, 'catalog_charset', 'UTF-8', 'NULL', 'catalog default charset', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (24, 'num_news', '2', '', 'Number of news at index page', 'text', 'index_page');
INSERT INTO `zok_option` VALUES (25, 'num_featured', '4', NULL, 'Number of featured posts at index page', 'text', 'index_page');
INSERT INTO `zok_option` VALUES (26, 'num_recent', '5', NULL, 'Number of recent posts at index page', 'text', 'index_page');
INSERT INTO `zok_option` VALUES (27, 'num_top', '5', NULL, 'Number of top rated posts at index page', 'text', 'index_page');
INSERT INTO `zok_option` VALUES (28, 'security_code_comment', '1', 'NULL', 'Security images for comments', 'checkbox', 'post');
INSERT INTO `zok_option` VALUES (30, 'post_title_characters', '250', 'NULL', 'Max limit of post title, characters', 'text', 'post');
INSERT INTO `zok_option` VALUES (31, 'site_title', 'Zoki Catalog Demo', NULL, 'Catalog Title', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (32, 'site_description', 'Zoki Catalog description', NULL, 'Catalog description', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (33, 'site_keywords', 'catalog, seo friendly', NULL, 'Catalog Keywords', 'text', 'catalog');
INSERT INTO `zok_option` VALUES (34, 'category_icon_width', '48', NULL, 'Width of category icon', 'text', 'category');
INSERT INTO `zok_option` VALUES (35, 'category_icon_height', '48', NULL, 'Height of category icon', 'text', 'category');
INSERT INTO `zok_option` VALUES (36, 'user_nick_max', '15', NULL, 'Max length of user nickname', 'text', 'user');
INSERT INTO `zok_option` VALUES (37, 'user_nick_min', '3', NULL, 'Min length of user nickname', 'text', 'user');
INSERT INTO `zok_option` VALUES (38, 'user_pass_max', '15', NULL, 'Max length of user password', 'text', 'user');
INSERT INTO `zok_option` VALUES (39, 'user_pass_min', '5', NULL, 'Min length of user password', 'text', 'user');
INSERT INTO `zok_option` VALUES (42, 'num_random', '5', NULL, 'Number of random posts at index page', 'text', 'index_page');
INSERT INTO `zok_option` VALUES (43, 'ads_code', '', NULL, 'place code of your google ads or banner ( html allowed )', 'textarea', 'ads');
INSERT INTO `zok_option` VALUES (44, 'openid', '1', NULL, 'enable login and join using OpenId account', 'checkbox', 'catalog');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post`
-- 

CREATE TABLE `zok_post` (
  `Id` int(11) NOT NULL auto_increment,
  `CategoryId` int(11) NOT NULL default '0',
  `UserId` int(11) NOT NULL default '0',
  `PicArrange` enum('column','slideshow') NOT NULL default 'slideshow',
  `PrimaryPicId` int(11) NOT NULL default '0',
  `DateSubmit` datetime NOT NULL default '0000-00-00 00:00:00',
  `DateEdit` datetime NOT NULL default '0000-00-00 00:00:00',
  `DateStart` date NOT NULL default '0000-00-00',
  `DateEnd` date NOT NULL default '0000-00-00',
  `Country` varchar(3) NOT NULL default 'all',
  `BaseName` varchar(60) NOT NULL default '',
  `SubType` enum('regular','featured','news') NOT NULL default 'regular',
  `Status` enum('active','inactive','deleted') NOT NULL default 'inactive',
  PRIMARY KEY  (`Id`),
  KEY `CategoryId` (`CategoryId`,`UserId`),
  KEY `Status` (`Status`),
  KEY `UserId` (`UserId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_post`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_cdata`
-- 

CREATE TABLE `zok_post_cdata` (
  `Id` int(11) NOT NULL auto_increment,
  `FieldId` mediumint(11) NOT NULL default '0',
  `Lang` varchar(20) NOT NULL default '',
  `Title` varchar(255) NOT NULL default '',
  `Values` text NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_cfield`
-- 

CREATE TABLE `zok_post_cfield` (
  `Id` int(11) NOT NULL auto_increment,
  `BaseName` varchar(20) NOT NULL default '',
  `FieldType` enum('num','tfield','textarea','radio','check','select') NOT NULL default 'num',
  `CategoryId` int(11) NOT NULL default '0',  
  `Display` tinyint(4) NOT NULL default '1',
  `Mode` enum('simple','req','adm') NOT NULL default 'simple',
  `FieldOrder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_clang`
-- 

CREATE TABLE `zok_post_clang` (
  `Id` int(11) NOT NULL auto_increment,
  `FieldId` int(11) NOT NULL default '0',
  `PostId` int(11) NOT NULL default '0',
  `Lang` varchar(20) NOT NULL default '',
  `Value` text NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
        

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_lang`
-- 

CREATE TABLE `zok_post_lang` (
  `Id` int(11) NOT NULL auto_increment,
  `PostId` int(11) NOT NULL default '0',
  `Lang` varchar(20) NOT NULL default '',
  `Title` varchar(255) NOT NULL default '',
  `Body` mediumtext NOT NULL,
  `Keywords` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`Id`),
  KEY `PostId` (`PostId`),
  KEY `Lang` (`Lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_post_lang`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_pic`
-- 

CREATE TABLE `zok_post_pic` (
  `Id` int(11) NOT NULL auto_increment,
  `PostId` int(11) NOT NULL default '0',
  `Pic` varchar(32) NOT NULL default '',
  `Ext` varchar(5) NOT NULL default '',
  `Description` varchar(255) NOT NULL default '',
  `Seq` int(2) NOT NULL default '0',
  PRIMARY KEY  (`Id`),
  KEY `PostId` (`PostId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_post_pic`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_post_stat`
-- 

CREATE TABLE `zok_post_stat` (
  `Id` int(11) NOT NULL auto_increment,
  `PostId` int(11) NOT NULL default '0',
  `View` int(11) NOT NULL default '0',
  `LastView` datetime NOT NULL default '0000-00-00 00:00:00',
  `Rate` int(11) NOT NULL default '0',
  `LastRate` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `PostId` (`PostId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_post_stat`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_rate_today`
-- 

CREATE TABLE `zok_rate_today` (
  `UserId` int(11) NOT NULL default '0',
  `PostId` int(11) NOT NULL default '0',
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  KEY `UserId` (`UserId`),
  KEY `PostId` (`PostId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Dumping data for table `zok_rate_today`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_sessions`
-- 

CREATE TABLE `zok_sessions` (
  `session_id` varchar(40) NOT NULL default '0',
  `ip_address` varchar(16) NOT NULL default '0',
  `user_agent` varchar(50) NOT NULL default '',
  `last_activity` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Dumping data for table `zok_sessions`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_static_content`
-- 

CREATE TABLE `zok_static_content` (
  `Id` int(11) unsigned NOT NULL auto_increment,
  `BaseName` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `BaseName` (`BaseName`),
  UNIQUE KEY `Id` (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Dumping data for table `zok_static_content`
-- 

INSERT INTO `zok_static_content` VALUES (1, 'faq');
INSERT INTO `zok_static_content` VALUES (2, 'about-us');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_static_lang`
-- 

CREATE TABLE `zok_static_lang` (
  `Id` int(11) NOT NULL auto_increment,
  `PageId` int(11) NOT NULL default '0',
  `Lang` varchar(20) NOT NULL default '',
  `Title` varchar(255) NOT NULL default '',
  `Content` mediumtext NOT NULL,
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

-- 
-- Dumping data for table `zok_static_lang`
-- 

INSERT INTO `zok_static_lang` VALUES (1, 1, 'english', 'faq', '<p>faq page</p>');
INSERT INTO `zok_static_lang` VALUES (2, 2, 'english', 'About Us', '<p>this page about our glorious team</p>');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user`
-- 

CREATE TABLE `zok_user` (
  `Id` int(11) NOT NULL auto_increment,
  `Name` varchar(32) NOT NULL default '',
  `Password` varbinary(32) NOT NULL default '',
  `Email` varchar(64) NOT NULL default '',
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `UserGroup` int(11) NOT NULL default '2',
  `UserFolder` varchar(32) NOT NULL default '',
  `Pic` varchar(32) NOT NULL default '',
  `Ext` varchar(4) NOT NULL default '',
  `Status` enum('active','inactive','deleted','unconfirmed') NOT NULL default 'inactive',
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `Name` (`Name`),
  UNIQUE KEY `Email` (`Email`),
  KEY `UserGroup` (`UserGroup`),
  KEY `Status` (`Status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

-- 
-- Dumping data for table `zok_user`
-- 

INSERT INTO `zok_user` VALUES (1, 'admin', 0x7a6f6b69, '', '0000-00-00 00:00:00', 1, '', '', '', 'active');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user_confirmation`
-- 

CREATE TABLE `zok_user_confirmation` (
  `Id` int(11) NOT NULL auto_increment,
  `UserId` int(11) NOT NULL default '0',
  `Hash` varchar(32) NOT NULL default '',
  `Date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`Id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_user_confirmation`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user_data`
-- 

CREATE TABLE `zok_user_data` (
  `Id` int(11) NOT NULL auto_increment,
  `UserId` int(11) NOT NULL default '0',
  `RealName` varchar(64) NOT NULL default '',
  `Description` text NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `UserId` (`UserId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_user_data`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user_group`
-- 

CREATE TABLE `zok_user_group` (
  `Id` int(11) NOT NULL auto_increment,
  `GroupName` varchar(20) NOT NULL default '',
  `Data` text NOT NULL,
  PRIMARY KEY  (`Id`),
  UNIQUE KEY `GroupName` (`GroupName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

-- 
-- Dumping data for table `zok_user_group`
-- 

INSERT INTO `zok_user_group` VALUES (1, 'admin', 'a:12:{s:13:"categ_to_hide";a:0:{}s:14:"categ_to_categ";a:1:{i:0;s:1:"0";}s:13:"categ_to_post";a:1:{i:0;s:1:"0";}s:16:"new_categ_status";s:6:"active";s:15:"new_post_status";s:6:"active";s:14:"post_total_num";s:1:"-";s:12:"post_pic_num";s:1:"-";s:19:"pic_max_upload_size";s:1:"-";s:20:"pic_max_upload_width";s:1:"-";s:21:"pic_max_upload_height";s:1:"-";s:13:"post_text_len";s:1:"-";s:13:"post_lifetime";s:1:"-";}');
INSERT INTO `zok_user_group` VALUES (2, 'member', 'a:12:{s:13:"categ_to_hide";a:0:{}s:14:"categ_to_categ";a:1:{i:0;s:1:"0";}s:13:"categ_to_post";a:1:{i:0;s:1:"0";}s:16:"new_categ_status";s:8:"inactive";s:15:"new_post_status";s:8:"inactive";s:14:"post_total_num";s:1:"-";s:12:"post_pic_num";s:2:"10";s:19:"pic_max_upload_size";s:4:"4096";s:20:"pic_max_upload_width";s:1:"-";s:21:"pic_max_upload_height";s:1:"-";s:13:"post_text_len";s:1:"-";s:13:"post_lifetime";s:1:"-";}');
INSERT INTO `zok_user_group` VALUES (3, 'guest', 'a:1:{s:13:"categ_to_hide";a:0:{}}');

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user_mailbox`
-- 

CREATE TABLE `zok_user_mailbox` (
  `Id` int(11) NOT NULL auto_increment,
  `UserId` int(11) NOT NULL default '0',
  `SenderId` int(11) NOT NULL default '0',
  `RecipientId` int(11) NOT NULL default '0',
  `Subject` varchar(255) NOT NULL default '',
  `Body` text NOT NULL,
  `DateSend` datetime NOT NULL default '0000-00-00 00:00:00',
  `Status` enum('read','unread','deleted') NOT NULL default 'unread',
  PRIMARY KEY  (`Id`),
  KEY `UserId` (`UserId`),
  KEY `SenderId` (`SenderId`),
  KEY `RecipientId` (`RecipientId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- 
-- Dumping data for table `zok_user_mailbox`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `zok_user_openid`
-- 

CREATE TABLE `zok_user_openid` (
  `OpenId` varchar(255) NOT NULL default '',
  `UserId` int(11) NOT NULL default '0',
  PRIMARY KEY  (`OpenId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- 
-- Dumping data for table `zok_user_openid`
-- 