<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/***************************************************************************
 *	PROJECT: ZokiSoft Smart Catalog
 *
 *	This program is a commercial software and any kind of using
 *	it must agree to ZokiSoft License Agreement.
 *
 *	This notice may not be removed from the code.
 *
 *	Copyright 2007-2008 ZokiSoft
 *	http://www.zokisoft.com/
 ***************************************************************************/

class Info extends Catalog_Controller
{

	/**
	 *	constructor
	 *
	 *	@param
	 *	@return
	 *
	 */
	function Info()
	{
		$this->sCurrentContr = 'info';
		parent::Catalog_Controller();

		$this->aHeaderVar['catalog_charset'] = $this->config->item('catalog_charset');

		$this->aSystemVar['template_viewer_root'] = $this->config->item('template_module_viewer');
		$this->aSystemVar['template_viewer_current'] = $this->config->item('template_viewer_info');
		$this->aSystemVar['current_location'] = $this->uri->uri_string();
		$this->aHeaderVar['additional_css'] = '<link href="' . $this->config->item('css', 'design') . 'static.css" rel="stylesheet" type="text/css" />';
	}



	function index( $page = '' )
	{
		$method = '_' . $page;
		$aPageList = array('_contact');


		if( in_array($method, $aPageList) and method_exists($this, $method) )
		{
			$this->{$method}();
			return true;
		}

		if ( '' != $this->aSystemVar['cur_lang_postfix'] )
			$page .= '_'.$this->aSystemVar['cur_lang'];

		if( is_file($this->config->item('base_dir') . 'views/_page/' . $page . EXT) )
		{
			$this->load->view( '_page/' . $page );
		}
		else
		{
			show_404();
			return false;
		}
	}


	function _contact()
	{
		$this->load->library('validation');

		$aData = array();
		$aData['Contact']['MailSent'] = false;

		if( $this->input->post('submit') )
		{
			$this->load->library('validation');

			$rules['recipient']		= "required";
			$rules['name']			= 'trim|required|xss_clean';
			$rules['email']			= 'trim|required|valid_email';
			$rules['subject']		= 'trim|required|xss_clean';
			$rules['message']		= 'trim|required|xss_clean';
			if ( $this->config->item('security_code') )
				$rules['SecurityCode']	= "required|strtoupper|callback__security_code_check";

			$this->validation->set_rules($rules);
			$this->validation->set_error_delimiters('<div class="error">', '</div>');
			if($this->validation->run() == FALSE)
			{
				$aData['Contact']['form']['recipient'] = $this->input->post('recipient');
				$aData['Contact']['form']['name'] = $this->input->post('name');
				$aData['Contact']['form']['email'] = $this->input->post('email');
				$aData['Contact']['form']['subject'] = $this->input->post('subject');
				$aData['Contact']['form']['message'] = $this->input->post('message');

			}
			else
			{
				$this->load->library('email');

				switch($this->input->post('recipient'))
				{
					case 'admin':
						$recipient = $this->config->item('mail_admin');
					break;
					case 'links':
						$recipient = $this->config->item('mail_links');
					break;
					case 'advert':
						$recipient = $this->config->item('mail_advert');
					break;
					case 'general':
					default:
						$recipient = $this->config->item('mail_general');
					break;
				}
				$this->email->from($this->input->post('email'), $this->input->post('name'));
				$this->email->to($recipient);

				$this->email->subject( $this->config->item('site_title') . ' [' . $this->input->post('subject') . '] ');
				$this->email->message($this->input->post('message'));
				$aData['Contact']['MailSent'] = $this->email->send();
			}
		}

		//$this->output->enable_profiler(TRUE);
		$this->load->helper('form');
		$this->aHeaderVar['page_title'] = $this->lang->line('_contact_us');

		$aData['Contact']['SecurityCode'] =	$this->config->item('security_code');
		$this->load->view( $this->aSystemVar['template_viewer_current'] . 'contact', $aData );

	}

/*
*
*	check for security code
*
*	@param - user's version of security code
*
*	@return bool
*
*/
	function _security_code_check( $sCode = '' )
	{

		if ( '1' != $this->config->item('security_code') )
		return TRUE;


		if ( empty($sCode) || md5($sCode) != $this->session->userdata('securityhash') )
		{
			$this->validation->set_message('_security_code_check', $this->lang->line('_security_code_check') );
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
}

/* End of file info.php */
/* Location: ./system/application/controllers/info.php */