<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

/***************************************************************************
 *	PROJECT: ZokiSoft Smart Catalog
 *
 *	This program is a commercial software and any kind of using
 *	it must agree to ZokiSoft License Agreement.
 *
 *	This notice may not be removed from the code.
 *
 *	Copyright 2007-2008 ZokiSoft
 *	http://www.zokisoft.com/
 ***************************************************************************/

class Async extends Catalog_Controller
{

/*
*
*	constructor
*
*/
	function Async()
	{
		
		parent::Catalog_Controller();
		
		// set lang file
		$this->lang->load('catalog_asynchelp',$this->aSystemVar['cur_lang']);

// on some systems this header is required
//		header('Content-Length: ' . strlen($sMessage) );

	}

/*
*
*	index
*
*/
	function index()
	{

		redirect('');

	}

/*
*
*	echo translation of given language key
*
*	@param - key for lang file
*
*	@return string
*
*/
	function topic( $sHelpRequest )
	{

		if ( !preg_match( '/^\w+$/', $sHelpRequest ) )
			return '';

		$sAnswer = $this->lang->line( $sHelpRequest );

//		$sAnswer = preg_replace('/__(.+?)__/', $this->config->item(''), $sAnswer);

		preg_match_all( '/__(.+?)__/', $sAnswer, $aConfig );
		$aConfigItem = $aConfig[1];

		if ( 0 < count($aConfigItem) )
		{
			foreach ( $aConfigItem as $sItem )
			{
				$aPattern[] = '/__' . $sItem . '__/';
				
				if ( 0 == strpos($sItem,'#gr#') )
				{
					$sGrValue = $this->_grGetValue(substr($sItem,4));
					if ( '-' == $sGrValue )
						$aReplacement[] = 'unlimited';
					else
						$aReplacement[] = $this->_grGetValue(substr($sItem,4));
				}
				elseif (strpos($sItem,','))
				{
					$aItem = explode(',',$sItem,2);
					$aReplacement[] = $this->config->item($aItem[1],$aItem[0]);
				}
				else
					$aReplacement[] = $this->config->item($sItem);
			}

			$sAnswer = preg_replace( $aPattern, $aReplacement, $sAnswer);

		}

// encoding of lang lile
//		header('Content-Type: text/html; charset=UTF-8');
//		header('Content-Length: ' . strlen($sAnswer) );
		echo $sAnswer;
		return TRUE;

	}


/*
*
*	add rate to given post id
*
*	@param - key for lang file
*
*	@return string
*
*/
	function rate_post( $iPostId, $sRate )
	{

		if ( !is_numeric($iPostId) || !preg_match( '/^\w+$/', $sRate ) )
			return false;

		if ( !$this->bLogIn )
		{
			echo '_rate_login';
			return false;
		}

// check for owner
		$this->db->select('`zok_post`.`UserId`');
		$this->db->where('`zok_post`.`Id` = \'' . $iPostId . '\' AND `zok_post`.`UserId` = \''.$this->aSystemVar['current_user']['Id'].'\'');
		$rRes = $this->db->get('`zok_post`');
		if ( 0 < $rRes->num_rows() )
		{
			echo '_rate_owner';
			return false;
		}

		$sNow = date("Y-m-d H:i:s");

// check for double rate
		$this->db->select('`zok_rate_today`.`UserId`');
		$this->db->where('`zok_rate_today`.`PostId` = \'' . $iPostId . '\' AND `zok_rate_today`.`UserId` = \''.$this->aSystemVar['current_user']['Id'].'\' AND DATE_ADD( `zok_rate_today`.`Time`, INTERVAL 1 DAY) > NOW()');
		$rRes = $this->db->get('`zok_rate_today`');
		if ( 0 < $rRes->num_rows() )
		{
			echo '_rate_voted';
			return false;
		}
		else
			$this->db->insert('`zok_rate_today`', array('UserId' => $this->aSystemVar['current_user']['Id'], 'PostId' => $iPostId, 'Time' => $sNow ) );


// clear old records from database
		if ( rand(1,100) < 5 )
		{
			$this->db->where('  DATE_ADD( `zok_rate_today`.`Time`, INTERVAL 1 DAY) < NOW() ');
			$this->db->delete('`zok_rate_today`');
		}


		if ( 'up' == $sRate )
			$iRate = 1;
		else
			$iRate = -1;

//		$this->db->query('INSERT INTO `zok_post_rate` (`PostId`, `Rate`, `LastRate`) VALUES (\'' . $iPostId . '\', \'' . $iRate . '\', \'' . $sNow .'\') ON DUPLICATE KEY UPDATE `Rate`=`Rate`+' . $iRate . ', `LastRate`=\'' . $sNow . '\'');
		$this->db->query( 'UPDATE `zok_post_stat` SET `Rate`=`Rate`+' . $iRate .', `LastRate`=\'' . $sNow . '\' WHERE `PostId`=' . $iPostId );

		echo $sRate;
		return true;

	}


/*
*
*	check for unique user nickname
*
*	@param - NickName
*
*	@return bool
*
*/
	function unique_nickname_check( $sNick = '' )
	{

		if ( !preg_match('/^\w+$/', $sNick) )
		{
			echo 'false';
			return FALSE;
		}

		$iLength = strlen( $sNick );

		if ( $iLength > $this->config->item('user_nick_max') || $iLength < $this->config->item('user_nick_min') )
		{
			echo 'false';
			return FALSE;
		}

		$this->db->select('`zok_user`.`Id`');
		$this->db->where('`zok_user`.`Name` = \'' . $sNick . '\'');
		$rRes = $this->db->get('`zok_user`');

		if ( 0 < $rRes->num_rows() )
		{
			echo 'false';
			return FALSE;
		}
		else
		{
			if($this->config->item('installed', 'forum') )
			{
				$this->db->select('user_id');
				$this->db->where('username', $sNick);
				$this->db->orwhere('username_clean', $sNick);
				$rForum = $this->db->get('`phpbb_users`');

				if( 0 < $rForum->num_rows() )
				{
					echo 'false';
					return false;
				}
			}
			echo 'true';
			return TRUE;
		}

	}


	function get_mail_body( $iMailId = '' )
	{

		if ( !is_numeric($iMailId) )
			return false;

		if ( !$this->bLogIn )
			return false;

		$this->db->select('`zok_user_mailbox`.`Body`');
		$this->db->where('`zok_user_mailbox`.`Id` = \'' . $iMailId . '\' AND `zok_user_mailbox`.`UserId` = \''.$this->aSystemVar['current_user']['Id'].'\'');
		$rRes = $this->db->get('`zok_user_mailbox`');

// may be this is Admin, checking his users ??
		if ( 0 == $rRes->num_rows() && $this->bAdmin )
		{
			$this->db->select('`zok_user_mailbox`.`Body`');
			$this->db->where('`zok_user_mailbox`.`Id` = \'' . $iMailId . '\'');
			$rRes = $this->db->get('`zok_user_mailbox`');
			$aMail = $rRes->row_array();
		}

		$aMail = $rRes->row_array();


		if ( empty($aMail['Body']))
			return false;
		else
		{
// set mail status to "read"
			$this->db->where('`zok_user_mailbox`.`Id` = \'' . $iMailId . '\' AND `zok_user_mailbox`.`UserId` = \''.$this->aSystemVar['current_user']['Id'].'\'');
			$this->db->update('`zok_user_mailbox`', array( '`Status`' => 'read' ) );
			echo $aMail['Body'];
		}

		return true;

	}


	function get_xml_category_list( $iParentCategory = 0 )
	{

		$iParentCategory = (int)$iParentCategory;

		$this->db->select('`zok_category`.`Id`, `zok_category`.`Title`, `zok_category`.`BaseName`');
		$this->db->where('`zok_category`.`ParentId` = \'' . $iParentCategory . '\'');
		if ( '1' == $this->config->item('premoderation') )
			$this->db->where(' `zok_category`.`Status` = \'active\' ');
		else
			$this->db->where(' `zok_category`.`Status` != \'deleted\' ');
		$rRes = $this->db->get('`zok_category`');

		header('Content-Type: application/xml');
/*
		$sContent = "<?xml version='1.0' encoding='" . $this->config->item('catalog_charset') . "'?>";
*/

		$sContent = "<root>";

		foreach ( $rRes->result_array() as $aCategory )
		{
			$sContent .= "<category>";

			$sContent .= "<id>{$aCategory['Id']}</id>";
			$sContent .= "<title><![CDATA[{$aCategory['Title']}]]></title>";
			$sContent .= "<basename>{$aCategory['BaseName']}</basename>";

			$sContent .= "</category>";
		}

		$sContent .= "</root>";

		echo $sContent;

	}

}

/* End of file async.php */
/* Location: ./system/application/controllers/async.php */