<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

// =====================================
// Site template

$config['template'] = 'marine';
//$config['template'] = 'default_blue';

// =====================================
//  Template paths:

$config['template_module']			= $config['template'] . '/catalog/';
$config['template_module_viewer']	= $config['template_module'] . 'viewer/';
$config['template_viewer_catalog']	= $config['template_module_viewer'] . 'catalog/';
$config['template_viewer_user']		= $config['template_module_viewer'] . 'user/';
$config['template_viewer_post']		= $config['template_module_viewer'] . 'post/';
$config['template_viewer_category']	= $config['template_module_viewer'] . 'category/';
$config['template_viewer_info']		= $config['template_module_viewer'] . 'info/';
$config['template_viewer_mailbox']	= $config['template_module_viewer'] . 'mailbox/';
$config['template_viewer_cron']		= $config['template_module_viewer'] . 'cron/';
$config['template_viewer_admin']	= $config['template_module_viewer'] . 'admin/';
$config['template_viewer_rss']		= $config['template_module_viewer'] . 'rss/';
$config['template_viewer_page']		= $config['template_module_viewer'] . 'page/';
$config['template_viewer_openid']	= $config['template_module_viewer'] . 'openid/';

$config['user_no_thumb']		= 'user_no_thumb.jpg';
$config['user_no_icon']			= 'user_no_icon.jpg';
$config['thumb_no_post']		= 'post_no_thumb.jpg';

$config['design_pic_path'] 		= 'views/' . $config['template_module'] . 'images/';
$config['design_pic_url'] 		= 'views/' . $config['template_module'] . 'images/';
$config['design_icon_url'] 		= $config['design_pic_url'] . 'icons/';
$config['design_css_url']		= 'views/' . $config['template_module'] . 'css/';
$config['design_js_url']		= 'views/' . $config['template_module'] . 'js/';

$config['flag_url']				= $config['design_pic_url'] . 'flags/';

// =====================================
//  Custom config path:

$config['config_custom_path'] = 'system/application/config/';
$config['config_custom_name'] = 'config_catalog_custom.php';

// =====================================
// category & post URL prefixes

$config['uri_category']	= 'listing/';
$config['uri_post']		= 'article/';

// =====================================
// mail boxes

$config['mail_reply']		= 'info@redbrooktech.com';
$config['mail_general']		= 'info@redbrooktech.com';
$config['mail_admin']		= 'info@redbrooktech.com';
$config['mail_links']		= 'info@redbrooktech.com';
$config['mail_advert']		= 'info@redbrooktech.com';

// =====================================
// User Data configuration:

$config['user_data_path']		= "system/application/uploads/users/";
$config['user_data_url']		= "system/application/uploads/users/";

// =====================================
//  Global pic configuration:

$config['catalog_image_library']= 'GD2';
$config['catalog_image_type']	= 'gif|jpg|png';

// =====================================
// Security image:

$config['font_ttf_path']		= 'system/fonts/arialbd.ttf';

// =====================================
// Date format for sql queries

$config['long_date_format']			= 'Y-m-d H:i:s';

// =====================================
// FILES configuration:

$config['file_file_type']		= 'sql|txt|zip|rar';
$config['file_file_max_size']	= '10000';
$config['user_file_folder']		= "files/";

// =====================================
// Post Pics configuration

$config['post_pic_path']		= "system/application/uploads/post/";
$config['post_pic_url']			= "system/application/uploads/post/";

// =====================================
// Category Pics configuration

$config['category_pic_path']		= "system/application/uploads/category/";
$config['category_pic_url']			= "system/application/uploads/category/";

// =====================================
// Breadcrumb divider

$config['breadcrumb_divider']		= "&#8250;";

// =====================================
// =====================================
// =====================================
// =====================================
// Main menu

$config['main_menu']['general']	=	array();
$config['main_menu']['visitor']	=	array();
$config['main_menu']['member']	=	array();
$config['main_menu']['admin']	=	array();

// =====================================
// General menu

// =====================================
// Visitor menu

$config['main_menu']['visitor']['forgot_password']	=	array(
														'url'	=>	'user/forgot_password/',
														'param'		=>	'',
														'lang_key'	=>	'forgot_password_q'
													);

$config['main_menu']['visitor']['registration']		=	array(
														'url'	=>	'user/registration/',
														'param'		=>	'',
														'lang_key'	=>	'user_registration'
													);

// =====================================
// Admin menu

$config['main_menu']['admin']['admin']			=	array(
													'url' 		=> 	'admin/',
													'param'		=>	'',
													'lang_key'	=>	'home'
												);

$config['main_menu']['admin']['category_list']	=	array(
													'url' 		=> 	'admin/category_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_category_list'
												);

$config['main_menu']['admin']['post_list']		=	array(
													'url' 		=> 	'admin/post_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_post_list'
												);

$config['main_menu']['admin']['user_list']		=	array(
													'url' 		=> 	'admin/user_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_user_list'
												);

$config['main_menu']['admin']['comment_list']	=	array(
													'url' 		=> 	'admin/comment_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_comment_list'
												);

$config['main_menu']['admin']['option_list']	=	array(
													'url' 		=> 	'admin/option_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_option_list'
												);


$config['main_menu']['admin']['mass_mailer']	=	array(
													'url' 		=> 	'admin/mass_mailer',
													'param'		=>	'',
													'lang_key'	=>	'adm_mass_mailer'
												);


$config['main_menu']['admin']['email_template']	=	array(
													'url' 		=> 	'admin/email_template',
													'param'		=>	'',
													'lang_key'	=>	'adm_email_template'
												);


$config['main_menu']['admin']['langs']	=	array(
													'url' 		=> 	'admin/langs',
													'param'		=>	'',
													'lang_key'	=>	'adm_langs'
												);

$config['main_menu']['admin']['static']	=	array(
													'url' 		=> 	'admin/stat_list',
													'param'		=>	'',
													'lang_key'	=>	'adm_static'
												);

$config['main_menu']['admin']['trash']			=	array(
													'url' 		=> 	'admin/trash',
													'param'		=>	'',
													'lang_key'	=>	'adm_trash'
												);


// =====================================
// Member menu

$config['main_menu']['member']['profile']['home']				=	array(
														'url' 		=> 	'',
														'param'		=>	'',
														'lang_key'	=>	'home'
													);


$config['main_menu']['member']['profile']['profile_edit']		=	array(
														'url'		=>	'user/profile_edit/',
														'param'		=>	'user_name',
														'lang_key'	=>	'my_profile'
													);

$config['main_menu']['member']['profile']['profile_view']		=	array(
														'url'		=>	'user/profile/',
														'param'		=>	'user_name',
														'lang_key'	=>	'view_profile'
													);

$config['main_menu']['member']['profile']['mailbox']			=	array(
														'url'		=>	'mailbox/inbox',
														'param'		=>	'',
														'lang_key'	=>	'mailbox'
													);

$config['main_menu']['member']['profile']['owner_posts']		=	array(
														'url'		=>	'post/roll/',
														'param'		=>	'user_name',
														'lang_key'	=>	'post_list'
													);


$config['main_menu']['member']['actions']['post_add']			=	array(
														'url'	=>	'post/add/',
														'param'		=>	'category_id',
														'lang_key'	=>	'post_add'
													);

$config['main_menu']['member']['actions']['category_add']			=	array(
														'url'	=>	'category/add/',
														'param'		=>	'category_id',
														'lang_key'	=>	'suggest_category'
													);

$config['main_menu']['member']['profile']['logout']			=	array(
														'url'	=>	'user/logout',
														'param'		=>	'',
														'lang_key'	=>	'logout'
													);



/* End of file config_catalog.php */
/* Location: ./system/application/config/config_catalog.php */